/*
 * Copyright 2013 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Author: jefftk@google.com (Jeff Kaufman)

#include "ngx_list_iterator.h"

namespace net_instaweb {

NgxListIterator::NgxListIterator(ngx_list_part_t* part) :
    part_(part),
    index_within_part_(0) {}

ngx_table_elt_t* NgxListIterator::Next() {
  if (index_within_part_ >= part_->nelts) {
    if (part_->next == NULL) {
      return NULL;
    }
    part_ = part_->next;
    index_within_part_ = 0;
  }
  ngx_table_elt_t* elts = static_cast<ngx_table_elt_t*>(part_->elts);
  return &elts[index_within_part_++];  // Intentional post-increment.
}

}  // namespace net_instaweb
