#include <gtk/gtk.h>

typedef unsigned char bool_t;

/*
 * PUBLIC: do_dialog()
 *
 * generic routine to create a dialog box.
 *
 * PARAMETERS:
 *     title   - title of dialog box.  if NULL, default is "Dialog Title"
 *     msg     - message to user.  if NULL, default is "Hello world!"
 *     num     - number of buttons.
 *     buttons - array of button text.  e.g., { "Yes", "No", "Cancel" }
 *               use GE_BUTTON_OK (et al) for both Gnome and non-Gnome.
 *               see dialog.h for definitions.
 *     dflt    - default button number, starting at 1.  -1 for no default.
 *     cbs     - array of callback functions.  if cbs is NULL, then the
 *               default callback function will be used.
 *     cbd     - array of callback data.  if cbd is NULL, then the default
 *               callback data (dlgdata) is used.
 *     block   - blocking or not.  if blocking, do_dialog() does not return
 *               control back to the caller until the user has pushed one of
 *               the buttons (thus causing the dialog box to be destroyed).
 *               for now, this is always blocking.
 *
 * RETURN VALUES:
 *     blocking: number of button which was pushed by user, starting at 1.
 *     non-blocking: always returns success unless error.
 *     -1 if error.
 */
int
do_dialog(char *title, char *msg, short num, char **buttons, short dflt,
	  GtkSignalFunc **cbs, void **cbd, bool_t block);


/* Same as do_dialog, but includes a GtkJustification argument (otherwise
   the dialog text is centred by default) */
int
do_dialog_justify(char *title, char *msg, GtkJustification jtype, 
		  short num, char **buttons, short dflt,
		  GtkSignalFunc **cbs, void **cbd, bool_t block);


