#!/usr/bin/env python
# -*- coding: UTF8 -*-

# Python module gvr_gtk.py
# Autogenerated from gvr_gtk.glade
# Generated on Thu Mar 16 14:55:00 2006

# Warning: Do not delete or modify comments related to context
# They are required to keep user's code
# Reminder:
# "widgets in classes derivated from SimpleGladeApp is easy and intuitive.
# So, a widget created with glade you named 'bogus_widget' will be used in
# your code as 'self.bogus_widget'."
import version
app_name = "gvr_gtk"# used to set gettext
app_version = version.VERSION

import utils,Text
glade_dir = "gui-gtk"
locale_dir = utils.LOCALEDIR

from SimpleGladeApp import SimpleGladeApp
from SimpleGladeApp import bindtextdomain
import os,locale

import pygtk
pygtk.require('2.0')
import gtk

# tell gtk we gonna use threads 
import gobject
gobject.threads_init()

import Editors,Widgets

bindtextdomain(app_name, utils.get_locale(),locale_dir)
utils.set_locale()

class MainWin(SimpleGladeApp):
    def __init__(self, path="gvr_gtk.glade", root="MainWin", domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)
        # We setup key event callback here as WBCanvas can't recieve them ?? XXX
        self.MainWin.add_events( gtk.gdk.KEY_PRESS_MASK )
        
    #context MainWin.new {
    def new(self):
        self.statusbar = Widgets.StatusBar(self.statusbar1)
        self._setup_canvas()
        self.world_editor = None
        self.program_editor = None
        self.timerinterval = 150
        
    #context MainWin.new }

    #context MainWin custom methods {
    #--- Write your own methods here ---#            
    def _setup_canvas(self):
        # setup the canvas
        self.canvas = Widgets.Canvas()
        self.viewport = gtk.Viewport()
        self.scrolledwindow2.add(self.viewport)
        self.viewport.add(self.canvas)
        self.scrolledwindow2.show_all()
        self._set_sensitive_button('all',False)
        self.WB_ACTIVATED = False
    def _set_sensitive_button(self,button,value):
        """used to 'grey out' buttons.
        When the @button is 'all', all the buttons are handled.
        We also clear the statusbar if the buttons are disabled."""
        if button == 'all':
            for b in (self.button_abort,self.button_execute,
                        self.button_reload,self.button_step):
                b.set_sensitive(value)
        else:
            but = {'abort':self.button_abort,
                'reload':self.button_reload,
                'execute':self.button_execute,
                'step':self.button_step}[button]
            but.set_sensitive(value)
        if button == 'all' or button in ('reload','step') and value == False:
            self.statusbar.clear()
    def _worldeditor_observer_callback(self):
        self.world_editor = None
    def _programeditor_observer_callback(self):
        self.program_editor = None
        
    ## These are the callbacks mandatory for the controller
    def start(self,args):
        """This will start the GUI."""
        print 'start called with args>',args
        if args[0] and args[1]:
            wfile, pfile = args[0], args[1]
            self.on_new_world1_activate(file=wfile)
            self.on_new_program1_activate(file=pfile)
        self.MainWin.show()
        self.run()
    def get_timer(self):
        """The controller will call this and expect to get a timer object.
         The timer must provide the following methods:
         start, stop, set_func and set_interval
         see the timer docstrings for more info"""
        return Widgets.Timer()
    def get_timer_interval(self):
        return self.timerinterval
    def stop(self):
        """Stops the gui, not yet used"""
        pass
    def set_controller(self,contr):
        self.controller = contr
    def worldwin_gettext(self):
        if self.world_editor:
            wcode = self.world_editor.get_all_text()
            if wcode:
                return wcode
        self.show_warning(_("You don't have a world file loaded."))
    def codewin_gettext(self):
        if self.program_editor:
            wcode = self.program_editor.get_all_text()
            if wcode:
                return wcode
        self.show_warning(_("You don't have a program file loaded."))
    def highlight_line_code_editor(self,line):
        """ Controller calls this with the current line of code that's
        been executed after the execute button is pressed."""
        try:
            self.program_editor.editor.set_highlight(line)
        except Exception,info:
            print info
    def show_warning(self,txt):
        Widgets.WarningDialog(txt=txt)
    def show_error(self,txt):
        Widgets.ErrorDialog(txt=txt)
    def show_info(self,txt):
        Widgets.InfoDialog(txt=txt)
    def update_world(self,obj):
        """Called by the controller when the world is changed."""
        # canvas is the drawable from Widgets.Canvas
        self.canvas.draw_world(obj)
        pos = self.controller.get_robot_position()
        self.statusbar.update_robotposition(pos)
        beep = self.controller.get_robot_beepers()
        self.statusbar.update_robotbeepers(beep)
    def update_robot_world(self,obj,oldcoords=None):
        """Called by the controller when the robots position is changed."""
        self.canvas.draw_robot(obj,oldcoords)
        pos = self.controller.get_robot_position()
        self.statusbar.update_robotposition(pos)
    def update_beeper_world(self,obj):
        """Called by the controller when the beepers states are changed."""
        self.canvas.draw_beepers(obj)
    ### end of mcv methods
    #context MainWin custom methods }

    #context MainWin.on_MainWin_delete_event {
    def on_MainWin_delete_event(self, widget, *args):
        self.on_quit1_activate(widget)
        return True # Don't send the signal further
    #context MainWin.on_MainWin_delete_event }

    #context MainWin.on_new_world1_activate {
    def on_new_world1_activate(self,widget=None,file=''):
        # do we have already a editor open?
        if self.world_editor:
            return
        self.world_editor = WorldTextEditorWin(parent=self)
        self.world_editor.TextEditorWin.set_title(
                    '%s  ' % os.path.basename(file) + _('GvRng - World editor'))
        if file:
            txt = utils.load_file(file)
            self.world_editor.set_text(file,txt)
            self.on_button_reload()
        self.world_editor.TextEditorWin.show()
        self._set_sensitive_button('reload',True)
        self.world_editor.register_observer(self._worldeditor_observer_callback)
    #context MainWin.on_new_world1_activate }

    #context MainWin.on_open_world1_activate {
    def on_open_world1_activate(self,widget=None,file=''):
        # do we have already a editor open?
        if self.world_editor:
            return
        if file:
            self.on_new_world1_activate(widget,file)
            return
        path = ''
        dlg = FileDialog(action='open',title=_("Open GvR world"),ext='wld')
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            path = dlg.get_filename()
            if os.path.splitext(path)[1] != '.wld':
                self.show_error(_("Selected path is not a world file"))
                dlg.destroy()
                return
        elif response == gtk.RESPONSE_CANCEL:
            print 'Closed, no files selected'
            dlg.destroy()
            return
        dlg.destroy()
        self.on_new_world1_activate(self,path)
    #context MainWin.on_open_world1_activate }

    #context MainWin.on_new_program1_activate {
    def on_new_program1_activate(self, widget=None, file=''):
        self.program_editor = CodeTextEditorWin(parent=self)
        #print self.program_editor
        self.program_editor.TextEditorWin.set_title(
                '%s  ' % os.path.basename(file) + _('GvRng - Program editor'))
        if file:
            txt = utils.load_file(file)
            self.program_editor.set_text(file,txt)
        self.program_editor.TextEditorWin.show()
        for b in ('execute','step','abort'):
            self._set_sensitive_button(b,True)
        self.world_editor.register_observer(self._programeditor_observer_callback)
    #context MainWin.on_new_program1_activate }

    #context MainWin.on_open_program1_activate {
    def on_open_program1_activate(self, widget=None,file=''):
        if file:
            self.on_new_program1_activate(widget,file)
            return
        path = ''
        dlg = FileDialog(action='open',title=_("Open GvR program"),ext='gvr')
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            path = dlg.get_filename()
            if os.path.splitext(path)[1] != '.gvr':
                self.show_error(_("Selected path is not a program file"))
                dlg.destroy()
                return
        elif response == gtk.RESPONSE_CANCEL:
            print 'Closed, no files selected'
            dlg.destroy()
            return
        dlg.destroy()
        self.on_new_program1_activate(self,path)
    #context MainWin.on_open_program1_activate }

    #context MainWin.on_open_worldbuilder1_activate {
    def on_open_worldbuilder1_activate(self, widget, *args):
        self.WB_ACTIVATED = True
        self.windowtitle = self.MainWin.get_title()
        self.MainWin.set_title(_("GvR - Worldbuilder"))
        # first we disable all the buttons, we don't use them in WB.
        self._set_sensitive_button('all',False)
        # disable all menus except help
        self.menuitem1.set_sensitive(False)
        self.menuitem3.set_sensitive(False)
        # We activate the buttons reload and abort as they are now used by
        # the WB. The reload button reacts by reloading the canvas, just as
        # in a normal session. For the abort button we set a flag which is checked
        # by the on_button_abort callback to act as a WB 'quit' button.
        self._set_sensitive_button('reload',True)
        self._set_sensitive_button('abort',True)
        # As we don't have a world when we start WB we start with a empty world
        # with Guido in the bottom left corner facing east, no beepers.
        # We start with a localized statement.
        wcode = ["%s 1 1 %s 0" % (_("robot"),_("E"))]
        if self.world_editor and self.world_editor.get_all_text():
            # if there's an open world editor we use it's contents
            wcode = self.world_editor.get_all_text()
        else:
            self.world_editor = WorldTextEditorWin(parent=self)
            self.world_editor.TextEditorWin.set_title(_('GvRng - World editor'))
            self.world_editor.editor.set_text(wcode)
            self.world_editor.TextEditorWin.show()
        # When the world_editor is destroyed it will call the observer.
        # By doing this it will simulate a abort button event.
        self.world_editor.register_observer(self.on_button_abort)
        # store the canvas so we can restore it later
        # It's also to add a reference to it to make sure the Python GC don't
        # free it from memory
        # Do we need to keep it ???
        self.oldcanvas = self.canvas
        self.viewport.remove(self.canvas)
        # setup the wb canvas
        self.canvas = Widgets.WBCanvas(parent=self,wcode=wcode)
        self.viewport.add(self.canvas)
        self.scrolledwindow2.show_all()
        # reload an empty world into the canvas which is now the WB canvas.
        # The wb canvas 'is a' normal canvas so all the methods and logic we
        # use in a normal grv session apply also in a WB session. 
        self.on_button_reload()
        #self.on_gvr_worldbuilder1_activate()
    #context MainWin.on_open_worldbuilder1_activate }

    #context MainWin.on_quit1_activate {
    def on_quit1_activate(self, widget, *args):
        #print "on_quit1_activate called with self.%s" % widget.get_name()
        try:
            self.program_editor.on_quit2_activate()
        except Exception, info:
            pass
            #print info
        try:
            self.world_editor.on_quit2_activate()
        except Exception,info:
            pass
            #print info
        dlg = QuitDialog()
        dlg.QuitDialog.show()
    #context MainWin.on_quit1_activate }

    #context MainWin.on_set_speed1_activate {
    def on_set_speed1_activate(self, widget, *args):
        dlg = SetSpeedDialog()
        response = dlg.SetSpeedDialog.run()
        if response == gtk.RESPONSE_OK:
            self.timerinterval = dlg.get_choice()
        dlg.SetSpeedDialog.destroy()
    #context MainWin.on_set_speed1_activate }

    #context MainWin.on_gvr_lessons1_activate {
    def on_gvr_lessons1_activate(self, widget, *args):
        """Display the GvR lessons in the default browser.
        This only works if the gvr lessons package version 0.2 is installed."""
        import webbrowser
        file = os.path.join(utils.get_rootdir(),'docs','lessons','html','index.html')
        if os.path.exists(file):
            try:
                webbrowser.open(file,new=0)
            except webbrowser.Error,info:
                txt = str(info)+ '\n'+ "Be sure to set your env. variable 'BROWSER' to your preffered browser."
                self.show_warning(txt)
        else: 
            self.show_warning(_("Can't find the lessons.\nMake sure you have installed the GvR-Lessons package.\nCheck the GvR website for the lessons package.\nhttp://gvr.sf.net"))
    #context MainWin.on_gvr_lessons1_activate }

    #context MainWin.on_set_language1_activate {                            
    def on_set_language1_activate(self, widget, *args):                     
        dlg = SetLanguageDialog()
        response = dlg.SetLanguageDialog.run()
        if response == gtk.RESPONSE_OK:
            languagechoice = dlg.get_choice()
        dlg.SetLanguageDialog.destroy()
        #print "languagechoice",languagechoice
        utils.setRcEntry('lang',languagechoice)
    #context MainWin.on_set_language1_activate } 

    #context MainWin.on_gvr_reference1_activate {
    def on_gvr_reference1_activate(self, widget, *args):
        dlg = SummaryDialog()
        dlg.set_text(Text.OnRefText)
    #context MainWin.on_gvr_reference1_activate }

    def on_gvr_worldbuilder1_activate(self,*args):
        dlg = SummaryDialog()
        dlg.set_text(Text.OnWBText)

    #context MainWin.on_about1_activate {
    def on_about1_activate(self, widget, *args):
        #testing
        #self.button_abort.set_sensitive(False)
        dlg = AboutDialog()
    #context MainWin.on_about1_activate }

    #context MainWin.on_button_reload {
    def on_button_reload(self, *args):
        wcode = self.worldwin_gettext()
        if wcode:
            self.controller.on_button_reload(wcode)
        return True
    #context MainWin.on_button_reload }

    #context MainWin.on_button_step {
    def on_button_step(self, widget, *args):
        self.controller.on_button_step()
        return True
    #context MainWin.on_button_step }

    #context MainWin.on_button_execute {
    def on_button_execute(self, widget, *args):
        self.controller.on_button_execute()
        return True
    #context MainWin.on_button_execute }

    #context MainWin.on_button_abort {
    def on_button_abort(self, widget=None, *args):
        if self.WB_ACTIVATED:
            # we act now as a 'quit button for the WB
            # canvas is now a WBCanvas object
            # Reset everything for the 'normal' canvas
            self.MainWin.set_title(self.windowtitle)
            self.menuitem1.set_sensitive(True)
            self.menuitem3.set_sensitive(True)
            self._set_sensitive_button('all',False)
            self.scrolledwindow2.remove(self.viewport)
            # put back the gvr world canvas
            self._setup_canvas()
            if not widget:
                # If widget is None we are called by the WB in a situation
                # the user has destroyed the worldeditor.
                self.world_editor = None 
            if self.world_editor:
                self._set_sensitive_button('reload',True)
                self.on_button_reload()
            if self.program_editor:
                for b in ('execute','step','abort'):
                    self._set_sensitive_button(b,True)
        else:
            self.controller.on_button_abort()
    #context MainWin.on_button_abort }

    #context MainWin.on_statusbar1_text_popped {
    def on_statusbar1_text_popped(self, widget, *args):
        pass
    #context MainWin.on_statusbar1_text_popped }

    #context MainWin.on_statusbar1_text_pushed {
    def on_statusbar1_text_pushed(self, widget, *args):
        pass
    #context MainWin.on_statusbar1_text_pushed }

class QuitDialog(SimpleGladeApp):
    def __init__(self, path="gvr_gtk.glade", root="QuitDialog", domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)

    #context QuitDialog.new {
    def new(self):
        #print "A new QuitDialog has been created"
        pass
    #context QuitDialog.new }

    #context QuitDialog custom methods {
    #--- Write your own methods here ---#
    #context QuitDialog custom methods }

    #context QuitDialog.on_QuitDialog_delete_event {
    def on_QuitDialog_delete_event(self, widget, *args):
        self.QuitDialog.destroy()
    #context QuitDialog.on_QuitDialog_delete_event }

    #context QuitDialog.on_dialog_okbutton1_clicked {
    def on_dialog_okbutton1_clicked(self, widget, *args):
        self.quit()
    #context QuitDialog.on_dialog_okbutton1_clicked }

class AboutDialog(SimpleGladeApp):
    def __init__(self, path="gvr_gtk.glade", root="AboutDialog", domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)

    #context AboutDialog.new {
    def new(self):
        # label = self.text_label
        txt = version.ABOUT_TEXT % app_version
        self.text_label.set_text(txt)
        self.text_label.show()
        self.AboutDialog.show()
    #context AboutDialog.new }

    #context AboutDialog custom methods {
    #--- Write your own methods here ---#
    #context AboutDialog custom methods }

    #context AboutDialog.on_AboutDialog_delete_event {
    def on_AboutDialog_delete_event(self, widget, *args):
        self.AboutDialog.destroy()
    #context AboutDialog.on_AboutDialog_delete_event }


class FileDialog(gtk.FileChooserDialog):
    def __init__(self,action='open',title='',path=os.path.expanduser('~/*'),ext='wld'):
        #print "FileChooserDialog called",action,title,path,ext
        if action == 'open':
            act = gtk.FILE_CHOOSER_ACTION_OPEN
            but = gtk.STOCK_OPEN
        else:
            act = gtk.FILE_CHOOSER_ACTION_SAVE
            but = gtk.STOCK_SAVE
        gtk.FileChooserDialog.__init__(self,title=title,action=act,
                                  buttons=(gtk.STOCK_CANCEL,
                                        gtk.RESPONSE_CANCEL,
                                        but,
                                        gtk.RESPONSE_OK))
        try:
            if os.name == 'posix':
                startpath = os.path.expanduser('~/*')
            else:
                startpath = os.path.join(utils.get_rootdir())
        except:
            startpath = os.path.join(utils.get_rootdir())
        self.set_current_folder(startpath)
        wfilter = gtk.FileFilter()
        wfilter.set_name(_("Worlds"))
        wfilter.add_pattern('*.wld')
        self.add_filter(wfilter)

        pfilter = gtk.FileFilter()
        pfilter.set_name(_("Programs"))
        pfilter.add_pattern('*.gvr')
        self.add_filter(pfilter)
        
        if ext == 'wld':
            self.set_filter(wfilter)
        else:
            self.set_filter(pfilter)

class TextEditorWin(SimpleGladeApp):
    def __init__(self, path="gvr_gtk.glade", root="TextEditorWin", domain=app_name,parent=None, **kwargs):
        path = os.path.join(glade_dir, path)
        self.parent = parent
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)
        # loaded_file_path is used to determine the path to save to
        # It's set by set_text and save_as* methods.
        self.loaded_file_path = ''
        self.loaded_txt = []

    #context TextEditorWin.new {
    def new(self):
        """This implements a gtksourceview widget from Editors.py"""
        #print "A new TextEditorWin has been created"
        self.editor = Editors.Editor(self.scrolledwindow1)
        self.observers = []
    #context TextEditorWin.new }

    #context TextEditorWin custom methods {
    #--- Write your own methods here ---#
    def set_title(self,title):
        self.TextEditorWin.set_title(title)
    def get_all_text(self):
        try:
            txt = self.editor.get_all_text()
        except:
            txt = []
        return txt
    def set_text(self,path,txt):
        # path is the path from which the txt comes, we use it to determine
        # the path to save to.
        self.loaded_file_path = path
        self.editor.set_text(txt)
        # used to compare the contents of the editor when quiting
        # We first set the text and then get it again because we compare it
        # against the text returnt by a call to get_all_text
        self.loaded_txt = self.get_all_text()
    def register_observer(self,obs):
        """Register a observer.
        Observer object must be a callable function which takes no arguments.
        Observer will be notified when this object gets destroyed.
        Needed by the worldbuilder and MainWin."""
        self.observers.append(obs)
    def _notify_observers(self):
        try:
            for obs in self.observers:
                apply(obs)
        except Exception,info:
            print info
    def show_info(self):
        txt = "Sorry, not yet implemented\nUse the right mousebutton"
        Widgets.InfoDialog(txt=txt)
    #context TextEditorWin custom methods }

    #context TextEditorWin.on_TextEditorWin_delete_event {
    def on_TextEditorWin_delete_event(self, widget, *args):
        self.on_quit2_activate(widget)
    #context TextEditorWin.on_TextEditorWin_delete_event }

    #context TextEditorWin.on_save1_activate {
    def on_save1_activate(self, widget=None, txt=[]):
        if txt == []:
            txt = self.get_all_text()
            # used to compare the contents of the editor when quiting
            # We first set the text and then get it again because we compare it
            # against the text returnt by a call to get_all_text
            self.loaded_txt = txt 
        if txt == []:
            Widgets.WarningDialog(txt=_("No content to save"))
            return
        if self.loaded_file_path:
            status = utils.save_file(self.loaded_file_path,txt)
            if status:
               Widgets.ErrorDialog(txt=status)
            else:
                return True
        else:
            self.on_save_as1_activate(txt=txt)
    #context TextEditorWin.on_save1_activate }

    #context TextEditorWin.on_save_as1_activate {
    def on_save_as1_activate(self, widget=None, txt=[]):
        #print "save_as1_activate", txt
        dlg = FileDialog(action='save',title=_('Choose a file'),ext=str(self))
        response = dlg.run()
        if response == gtk.RESPONSE_OK:
            path = dlg.get_filename()
        elif response == gtk.RESPONSE_CANCEL:
            print 'Closed, no files selected'
            dlg.destroy()
            return True
        dlg.destroy()
        self.loaded_file_path=path
        if self.on_save1_activate(txt=txt):
            self.set_title(path)
    #context TextEditorWin.on_save_as1_activate }

    #context TextEditorWin.on_quit2_activate {
    def on_quit2_activate(self, widget=None, *args):
        edittxt = self.get_all_text()
        #print 'edittxt',edittxt
        #print 'loaded_txt',self.loaded_txt
        if edittxt != self.loaded_txt:
            dlg = Widgets.YesNoDialog(txt=_("The editor's content is changed.\nDo you want to save it?"))
            response = dlg.run()
            dlg.destroy()
            if response == gtk.RESPONSE_YES:
                self.on_save_as1_activate(txt=edittxt)
            else:
                pass
        self.TextEditorWin.destroy() 
        self.loaded_txt = []
        self.editor = None
        if str(self) == 'wld':
            self.parent._set_sensitive_button('reload',False)
        else:
            for b in ('execute','step','abort'):
                self.parent._set_sensitive_button(b,False)
        try:
            self.parent.canvas.draw_splash()
        except:
            pass
        self._notify_observers()
    #context TextEditorWin.on_quit2_activate }

    #context TextEditorWin.on_cut1_activate {
    def on_cut1_activate(self, widget, *args):
        self.editor.srcview.emit('cut-clipboard')
    #context TextEditorWin.on_cut1_activate }

    #context TextEditorWin.on_copy1_activate {
    def on_copy1_activate(self, widget, *args):
        self.editor.srcview.emit('copy-clipboard')
    #context TextEditorWin.on_copy1_activate }

    #context TextEditorWin.on_paste1_activate {
    def on_paste1_activate(self, widget, *args):
        self.editor.srcview.emit('paste-clipboard')
    #context TextEditorWin.on_paste1_activate }

    #context TextEditorWin.on_delete1_activate {
    def on_delete1_activate(self, widget, *args):
        self.editor.srcview.emit('delete-from-cursor',gtk.DELETE_CHARS,1)
    #context TextEditorWin.on_delete1_activate }
    
    #context TextEditorWin.on_print1_activate {                             
    def on_print1_activate(self, widget, *args):                            
        import time,tempfile
        head = '\nfile: %s\ndate: %s\n' % \
            (self.TextEditorWin.get_title().split(' ')[0],time.asctime())
        txt = '\n'.join(self.get_all_text())
        text = '-'*79 + '\n' + head + '-'*79 + '\n' + txt
        # create a secure tempfile, not really needed but I think you should
        # always try to avoid race conditions in any app.
        fd,fn = tempfile.mkstemp()
        fo = os.fdopen(fd,'w')
        try:
            fo.write(text)
            fo.close()
        except Exception,info:
            print info
            return
        utils.send_to_printer(fn)
        os.remove(fn)
    #context TextEditorWin.on_print1_activate }   

class CodeTextEditorWin(TextEditorWin):
    def __init__(self, path="gvr_gtk.glade", root="TextEditorWin", domain=app_name,parent=None, **kwargs):
        TextEditorWin.__init__(self,path,root,domain,parent,**kwargs)
    def __str__(self):
        return 'gvr'
class WorldTextEditorWin(TextEditorWin):
    def __init__(self, path="gvr_gtk.glade", root="TextEditorWin", domain=app_name,parent=None, **kwargs):
        TextEditorWin.__init__(self,path,root,domain,parent,**kwargs)
    def __str__(self):
        return 'wld'
        
class SetLanguageDialog(SimpleGladeApp):
    def __init__(self, path="gvr_gtk.glade", root="SetLanguageDialog", domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)

    #context SetLanguageDialog.new {
    def new(self):
        #print "A new SetLanguageDialog has been created"
        pass
    #context SetLanguageDialog.new }

    #context SetLanguageDialog custom methods {
    #--- Write your own methods here ---#
    def get_choice(self):
        try:
            choice = {'Catalan':'ca','Dutch':'nl','English':'en','French':'fr',\
                    'Norwegian':'no','Romenian':'ro','Spanish':'es','Italian':'it'}\
                    [Widgets.get_active_text(self.comboboxentry_language)]
        except Exception,info:
            print info
            choice = 'en'
        return choice
    #context SetLanguageDialog custom methods }

    #context SetLanguageDialog.on_SetLanguageDialog_delete_event {
    def on_SetLanguageDialog_delete_event(self, widget, *args):
        self.SetLanguageDialog.destroy()
    #context SetLanguageDialog.on_SetLanguageDialog_delete_event }

    #context SetLanguageDialog.on_okbutton3_clicked {
    def on_okbutton3_clicked(self, widget, *args):
        pass
    #context SetLanguageDialog.on_okbutton3_clicked }

class SetSpeedDialog(SimpleGladeApp):
    def __init__(self, path="gvr_gtk.glade", root="SetSpeedDialog", domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)

    #context SetSpeedDialog.new {
    def new(self):
        self.comboboxentry_speed.set_active(2)
    #context SetSpeedDialog.new }

    #context SetSpeedDialog custom methods {
    #--- Write your own methods here ---#
    def get_choice(self):
        try:
            choice = {'Instant':5,'Fast':50,'Medium':150,'Slow':500}\
                    [Widgets.get_active_text(self.comboboxentry_speed)]
        except Exception,info:
            print info
            choice = 150
        return choice
    #context SetSpeedDialog custom methods }

    #context SetSpeedDialog.on_SetSpeedDialog_delete_event {
    def on_SetSpeedDialog_delete_event(self, widget, *args):
        self.SetSpeedDialog.destroy()
    #context SetSpeedDialog.on_SetSpeedDialog_delete_event }

    #context SetSpeedDialog.on_okbutton4_clicked {
    def on_okbutton4_clicked(self, widget, *args):
        pass
    #context SetSpeedDialog.on_okbutton4_clicked }

class SummaryDialog(SimpleGladeApp):
    def __init__(self, path="gvr_gtk.glade", root="SummaryDialog", domain=app_name, **kwargs):
        path = os.path.join(glade_dir, path)
        SimpleGladeApp.__init__(self, path, root, domain, **kwargs)

    #context SummaryDialog.new {
    def new(self):
        pass
    #context SummaryDialog.new }

    #context SummaryDialog custom methods {
    #--- Write your own methods here ---#
    def set_text(self,txt):
        # first line is also used as the title
        title = txt.split('\n')[0]
        buffer = gtk.TextBuffer(table=None)
        try:
            txt = ''.join(txt)
            utxt = unicode(txt)
        except Exception,info:
            print "Failed to set text in source buffer"
            print info
            return
        self.SummaryDialog.set_title(title)
        buffer.set_text(utxt)
        self.textview1.set_buffer(buffer)
    #context SummaryDialog custom methods }

    #context SummaryDialog.on_SummaryDialog_delete_event {
    def on_SummaryDialog_delete_event(self, widget, *args):
        self.SummaryDialog.destroy()
    #context SummaryDialog.on_SummaryDialog_delete_event }

#context main {

def main():
    main_win = MainWin()
##    quit_dialog = QuitDialog()
##    about_dialog = AboutDialog()
##    file_dialog = FileDialog()
##    text_editor_win = TextEditorWin()
##    set_language_dialog = SetLanguageDialog()
##    set_speed_dialog = SetSpeedDialog()
##    summary_dialog = SummaryDialog()

    # SimpleGladeApp.run() must be called just once per program
    main_win.run()

if __name__ == "__main__":
    main()

#context main }
