/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#include "main.h"
#include "configure.h"
#include "interface.h"
#include "diskfree.h"
#include "pixmap.h"

gint last_width;

GdkPixbuf *
pixmap_draw_capacity (gint real, gint mounted, gint usedp, gint width)
{
	gint height = 12, mid, rgb[3];
	gchar *text;
	gfloat i, inc, max;
	GdkColor color, color2;
	GdkGC *gc;
	GdkPixmap *pixmap;
	GdkPixbuf *pixbuf = NULL;
	
	inc = (gfloat) width / 100;
	pixmap = gdk_pixmap_new(mwindow_attr.mwindow->window, width, height, -1);
       	gc = gdk_gc_new(pixmap);
	gdk_gc_set_line_attributes(gc, 1, GDK_LINE_SOLID,
				   GDK_CAP_BUTT, GDK_JOIN_MITER);
	/* Backgound color : white. */
	
	color.red = COLOR_MAX;
	color.green = COLOR_MAX;
	color.blue = COLOR_MAX;
	gdk_colormap_alloc_color(mwindow_attr.colorboard,
				 &color, TRUE, TRUE);
	gdk_gc_set_background(gc, &color);
	gdk_gc_set_foreground(gc, &color);
	gdk_draw_rectangle(pixmap, gc, TRUE, 0, 0, width, height);
	
	color.red = color.green = color.blue = 0;
	gdk_colormap_alloc_color(mwindow_attr.colorboard,
				 &color, TRUE, TRUE);
	gdk_gc_set_foreground(gc, &color);
	gdk_draw_rectangle(pixmap, gc, FALSE, 0, 0, width - 1, height - 1);
	
	/* Foreground color. */
	if (!real || mounted == FS_UMOUNTED) {
		color.red = color.green = color.blue = COLOR_MED + (COLOR_MED / 2);
		gdk_colormap_alloc_color(mwindow_attr.colorboard,
					 &color, TRUE, TRUE);
		gdk_gc_set_foreground(gc, &color);
		gdk_draw_rectangle(pixmap, gc, TRUE, 1, 1, width - 2, height - 2);
	} else if (options->capacity_style[0]) {
		color.red = (gint) (COLOR_MAX * options->color1[0]);
		color.green = (gint) (COLOR_MAX * options->color1[1]);
		color.blue = (gint) (COLOR_MAX * options->color1[2]);
		
		color2.red = (gint) (COLOR_MAX * options->color2[0]);
		color2.green = (gint) (COLOR_MAX * options->color2[1]);
		color2.blue = (gint) (COLOR_MAX * options->color2[2]);
		
		rgb[0] = (color.red - color2.red) / 100;
		rgb[1] = (color.green - color2.green) / 100;
		rgb[2] = (color.blue - color2.blue) / 100;
		gdk_colormap_alloc_color(mwindow_attr.colorboard,
					 &color, TRUE, TRUE);
		gdk_gc_set_foreground(gc, &color);
		
		i = 1.0;
		max = usedp * inc;
		while (((gint)(i + inc)) <((gint) max)) {
			for (mid = (gint)i ; mid <(gint)(i + inc) ; mid++)
				gdk_draw_line(pixmap, gc, mid, 1, mid, height - 1);
			color.red -= rgb[0];
			color.green -= rgb[1];
			color.blue -= rgb[2];
			gdk_colormap_alloc_color(mwindow_attr.colorboard,
						 &color, TRUE, TRUE);
			gdk_gc_set_foreground(gc, &color);
			i = i + inc;
		}
	} else {
		if (usedp <= options->color_levels[0]) {
			color.red = COLOR_MIN;
			color.green = COLOR_MED;
			color.blue = COLOR_MIN;
		} else if (usedp <= options->color_levels[1]) {
			color.red = COLOR_MAX;
			color.green = COLOR_MED;
			color.blue = COLOR_MIN;
		} else {
			color.red = COLOR_MAX;
			color.green = COLOR_MIN;
			color.blue = COLOR_MIN;
		}
		gdk_colormap_alloc_color(mwindow_attr.colorboard,
					 &color, TRUE, TRUE);
		gdk_gc_set_foreground(gc, &color);
		gdk_draw_rectangle(pixmap, gc, TRUE, 1, 1, (gint)(usedp * inc), height - 1);
	}
	
	/* Add text in capacity column ? */
	if (options->capacity_style[1]) {
		text = g_strdup_printf("%i %%", usedp);
		color.red = (gint) (COLOR_MAX * options->color_text[0]);
		color.green = (gint) (COLOR_MAX * options->color_text[1]);
		color.blue = (gint) (COLOR_MAX * options->color_text[2]);
		gdk_colormap_alloc_color(mwindow_attr.colorboard,
					 &color, TRUE, TRUE);
		gdk_gc_set_foreground(gc, &color);
		mid = (width / 2) - (gdk_string_measure(mwindow_attr.font, text) / 2) + 1;
		/*gdk_draw_layout();*/
		gdk_draw_string(pixmap, mwindow_attr.font, gc, mid, height - 1, text);
		g_free(text);
	}
	
	
      	pixbuf = gdk_pixbuf_get_from_drawable(pixbuf, pixmap, mwindow_attr.colorboard,
					      0, 0, 0, 0, width, height);
	
	/* Free the allocated structures, which have been copyed by
	 * the GTK. */
	gdk_gc_unref(gc);
	gdk_drawable_unref(pixmap);
	
	return pixbuf;
}

void
list_make_pixbuf (filesystem_t *fs, gint width)
{
	fs->pixbuf = pixmap_draw_capacity(fs->real, fs->mounted, fs->pused, width);
	
	return;
}

void
gui_list_capacity_redraw (GtkTreeIter *iter, gint width)
{
	gint percent, status;
       	GdkPixbuf *pixbuf;
	
	gtk_tree_model_get(list_treemodel, iter, USEDP_PERCENT_COLUMN, &percent,
			   STATUS_COLUMN, &status, -1);
	pixbuf = pixmap_draw_capacity(status, status, percent, width);
	gtk_list_store_set(GTK_LIST_STORE(list_treemodel), iter, CAPACITY_COLUMN, pixbuf, -1);
	
	return;
}

gboolean
gui_list_capacitys_redraw (void)
{
	gint width;
	GtkTreeViewColumn *column;
	GtkTreeIter iter;
	
	/* Get size of the capacity column. */
	if (options->capacity_style[2]) {
		column = gtk_tree_view_get_column(GTK_TREE_VIEW(list_treeview), CAPACITY_COLUMN);
		width = gtk_tree_view_column_get_width(column);
		width -= 6;
	} else
		width = options->capacity_style[3];
	
	/* If the capacity column has same width than the last time we
	 * update it, also we do nothing. Same thing if width <= 0. */
	if ((last_width == width && !gui_color_update) || (width <= 0))
		return FALSE;
	
	if (!gtk_tree_model_get_iter_first(list_treemodel, &iter))
		return FALSE;
	
	do {
		gui_list_capacity_redraw(&iter, width);
	} while (gtk_tree_model_iter_next(list_treemodel, &iter));
       	
	last_width = width;
	gui_color_update = FALSE;
	
	return FALSE;
}

void
gui_list_capacitys_draw (GList *list)
{
	gint width;
	filesystem_t *fs;
	GtkTreeViewColumn *column;
	
	if (list == NULL)
		return;
	
	/* Get size of the capacity column. */
	if (options->capacity_style[2]) {
		column = gtk_tree_view_get_column(GTK_TREE_VIEW(list_treeview), CAPACITY_COLUMN);
		width = gtk_tree_view_column_get_width(column);
		width -= 6;
	} else
		width = options->capacity_style[3];
	
	/* If the capacity column has same width than the last time we
	 * update it, else we do nothing. Same thing if width <= 0. */
		
	list = g_list_first(list);
	while (list != NULL) {
		fs = FILESYSTEM(list->data);
		if (fs->need_update || gui_color_update)
			list_make_pixbuf(fs, width);
		list = list->next;
	}
	
	last_width = width;
	gui_color_update = FALSE;
	
	return;
}
