/* GDK - The GIMP Drawing Kit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Modified by the GTK+ Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GTK+ Team.
 */

/*
 * GTK+ DirectFB backend
 * Copyright (C) 2001-2002  convergence integrated media GmbH
 * Copyright (C) 2002       convergence GmbH
 * Written by Denis Oliver Kropp <dok@convergence.de> and
 *            Sven Neumann <sven@convergence.de>
 */

#ifndef __GDK_DIRECTFB_H__
#define __GDK_DIRECTFB_H__

#include <directfb.h>

#include "gdk/gdk.h"

G_BEGIN_DECLS

typedef struct _GdkDirectFBDisplay GdkDirectFBDisplay;

#define GDK_ROOT_WINDOW()      (gdk_get_default_root_window ())
#define GDK_WINDOW_DFB_ID(win) (GDK_WINDOW_IMPL_DIRECTFB (GDK_WINDOW_OBJECT (win)->impl)->dfb_id)


extern GdkDirectFBDisplay *gdk_display;

/* used for the --transparent-unfocused hack */
extern gboolean            gdk_directfb_apply_focus_opacity;

/* used for the --enable-color-keying hack */
extern gboolean            gdk_directfb_enable_color_keying;
extern DFBColor            gdk_directfb_bg_color;
extern DFBColor            gdk_directfb_bg_color_key;

/* to disable antialiasing */
extern gboolean            gdk_directfb_monochrome_fonts;


/* GTK+-DirectFB specific functions */

void        gdk_directfb_window_set_opacity (GdkWindow             *window,
                                             guchar                 opacity);

GdkWindow * gdk_directfb_window_new         (GdkWindow             *parent,
                                             GdkWindowAttr         *attributes,
                                             gint                   attributes_mask,
                                             DFBSurfaceCapabilities surface_caps);

GdkVisual * gdk_directfb_visual_by_format   (DFBSurfacePixelFormat  pixel_format);


#endif /* __GDK_DIRECTFB_H__ */
