/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/  

#ifndef _Protocol_H_
#define _Protocol_H_

#include "Parser.h"

// Error Codes used within ProtocolExp
#define GET_ERROR 21
#define PUT_ERROR 22
#define BYE_ERROR 25

// Exception used when an error in protocol has occured.
// (See Parser.h for addditional error codes and ParseExp info)
class ProtocolExp : public ParseExp {
public:
	ProtocolExp() throw();
	ProtocolExp( const char *msg, int code = 0 ) throw();
	ProtocolExp( const ProtocolExp& ) throw();
	virtual ProtocolExp& operator=( const ProtocolExp& exp ) throw();
};

/* class Protocol
 * Every class implementing a protocol should extend this class.  By using
 * its protocol() method, this class will parse through the protocol
 * (using the parse() method from a class derived from class Parse).  The class
 * deriving Protocol should have an implementaion of all virtual methods
 * from the Parse-dervied class -- for only those methods that it needs.
 */
class Protocol {
public:
	/* protocol()
	 * This method should basically call parse() of the Parse-derived
	 * class so the protocol parsing would occur.  The parse() method
	 * will call all virtual callback methods.
	 */
	virtual int protocol() throw(ProtocolExp) = 0;

	virtual ~Protocol() { }
};

#endif  // _Protocol_H_
