#ifndef _GUICOMMON_H_
#define _GUICOMMON_H_

#ifdef GRUB_UNIX
#	include <unistd.h>
#	include <pthread.h>
#	include <netinet/in.h>
#	include <netdb.h>
#else  /* GRUB_UNIX */
#	include <winsock.h>
#endif  /* ! GRUB_UNIX */

#ifdef GRUB_UNIX
typedef int SOCKET;
#define INVALID_SOCKET (-1)
#define SOCKET_ERROR (-1)
#define closesocket close
#else   /* GRUB_UNIX */
#endif  /* ! GRUB_UNIX */

#define GF_SUCCESS 0
#define GF_REINIT (-1)
#define GF_SOCKERR (-2)
#define GF_NOINIT (-3)
#define GF_NOTREADY (-4)
#define GF_INTRNERR (-5)
#define GF_BADDATA (-6)

#ifdef GRUB_UNIX
typedef pthread_t ThreadId;
typedef pthread_mutex_t MutexType;
#else
typedef unsigned long ThreadId;
typedef CRITICAL_SECTION MutexType;
#endif

#ifdef GRUB_UNIX
#define ALERT(text)
#define ALERTINT(text, number)
#define ALERTSTR(text, str)
#define ALERTWHERE()
#else
#define ALERT(text) ::MessageBox(NULL, text, "Alert", MB_OK)
#define ALERTINT(text, number) \
	do { \
		char buf[1024]; \
		sprintf( buf, "%s: %d", text, number ); \
		ALERT(buf); \
	} while(0)
#define ALERTSTR(text, str) \
	do { \
		char buf[1024]; \
		sprintf( buf, "%s: \"%s\"", text, str ); \
		ALERT(buf); \
	} while(0)
#define ALERTWHERE() \
	do { \
		char buf[1024]; \
		sprintf( buf, "%s: %d", __FILE__, __LINE__ ); \
		ALERT(buf); \
	} while(0)
#endif

#endif  /* _GUICOMMON_H_ */
