#include "GrubCLog.h"

using namespace std;

GrubCLog *client_log = 0;
GrubCLog *gui_log = 0;

GrubCLog::GrubCLog (char *fname, bool print_to_stdout, unsigned int level)
{
	unsigned int l;
	l = level;
	for(;l <= GCLOG_EMERG; l *= 2) level |= l;
		
	mylog = new GC_Log(fname, MAX_FILE_LEN, print_to_stdout, level, true);
}
	

int GrubCLog::Logprintf(unsigned int level, char *info, ...)
{
	char msg[MAX_MSG_LEN];
	int d;
	va_list ap;
	
	va_start(ap,info);
        d = vsprintf(msg,info,ap);
        if (d == -1) {
                va_end(ap);
        	return d;
	}
	mylog->logprintf(level, msg);
	va_end(ap);
        return 0;
}

	
GrubCLog::~GrubCLog()
{	
	delete mylog;
}



