#include <stdio.h>
#include "zstream.h"

/* Reads input data from inputfile (see below); compresses it into comprfile;
 * then uncompresses it and saves these uncompressed contents into origfile
 * (so that inputfile and origfile can be diff'ed).
 */

int infunc( int fd, char *buf, int len, void *arg )
{
	FILE *fp = (FILE *)arg;
	int ret;

	ret = fread( buf, 1, len, arg );

	return ( ret == 0 && ferror( fp ) ) ? -1 : ret;
}

int outfunc( int fd, const char *buf, int len, void *arg )
{
	FILE *fp = (FILE *)arg;
	int ret;

	ret = fwrite( buf, 1, len, fp );
	return ( ret == 0 && ferror( fp ) ) ? -1 : ret;
}

int main()
{
	const int zwritelen = 9000;
	const int zreadlen = 1000;
	const int buflen = 9000;
	const char *inputfile = "IN";
	const char *comprfile = "OUT";
	const char *origfile = "ORIG";

	z_stream *zw;
	z_stream *zr;
	char zwritebuf[204800];
	char zreadbuf[204800];
	char buf[204800];
	int ret;
	FILE *ifp;
	FILE *ofp;
	FILE *rfp;
	int end_of_file = 0;

	/* INIT */
	zw = zstream_deflate_init( ZS_DEFAULT_COMPRESSION );
	if ( !zw ) {

		fprintf(stderr, "zstream_deflate_init() failed\n");
		exit(1);
	}

	zr = zstream_inflate_init();
	if ( !zr ) {

		fprintf(stderr, "zstream_inflate_init() failed\n");
		exit(1);
	}

	/* PROCESS */

	ifp = fopen( inputfile, "rb" );
	if ( !ifp ) {

		perror("fopen");
		exit(1);
	}

	ofp = fopen( comprfile, "wb" );
	if ( !ofp ) {

		perror("fopen");
		exit(1);
	}

	while (1) {
		int fret;
		int retval;

		ret = fread( buf, 1, buflen, ifp );
		if ( ret == 0 && ferror( ifp ) ) {

			perror("fread");
			exit(1);
		}
		else if ( ret == 0 )
			break;

		fret = zwrite( zw, zwritebuf, zwritelen, fileno( ofp ),
			buf, ret, (void *)ofp, outfunc, &retval );
		if ( fret == ZS_CALLBACK ) {

			fprintf( stderr, "callback() = %d\n", retval );
		}
		else if ( fret != ZS_OK ) {

			fprintf( stderr, "write() %d", fret );
			exit(1);
		}
	}

	fclose( ifp );
	fclose( ofp );

	ifp = fopen( comprfile, "rb" );
	if ( !ifp ) {

		perror("fopen");
		exit(1);
	}

	rfp = fopen( origfile, "wb" );
	if ( !rfp ) {

		perror("fopen");
		exit(1);
	}

	while (1) {
		int fret;
		int retval;

		fret = zread( zr, zreadbuf, zreadlen, fileno( ifp ),
			buf, buflen, (void *)ifp, infunc, &retval );
		if ( fret == ZS_CALLBACK ) {

			if ( retval == 0 )
				break;
			else {

				fprintf( stderr, "callback() = %d\n", retval );
				exit(1);
			}
		}
		else if ( fret < 0 ) {

			fprintf( stderr, "write() = %d", fret );
			exit(1);
		}

		ret = fwrite( buf, 1, fret, rfp );
		if ( ret == 0 && ferror( rfp ) ) {

			perror("fread");
			exit(1);
		}
		else if ( ret == 0 )
			break;
	}

	printf("zstream_read_available %d\n", zstream_read_available( zr ) );

#if 0
	while ( zstream_read_available( zr ) ) {
		int fret;
		int retval;

		fret = zread( zr, zreadbuf, zreadlen, fileno( ifp ),
			buf, buflen, (void *)ifp, infunc, &retval );
		if ( fret < 0 ) {

			fprintf( stderr, "avail read = %d\n", fret );
			exit(1);
		}

		fret = fwrite( buf, 1, fret, rfp );
		if ( fret == 0 && ferror( rfp ) ) {

			perror("fread");
			exit(1);
		}
		else if ( fret == 0 )
			break;
	}
#endif

	fclose( ifp );
	fclose( rfp );

	/* END */
	ret = zstream_deflate_end( zw );
	if ( ret ) {

		fprintf(stderr, "zstream_deflate_end() failed\n");
		exit(1);
	}

	ret = zstream_inflate_end( zr );
	if ( ret ) {

		fprintf(stderr, "zstream_inflate_end() failed\n");
		exit(1);
	}

	return 0;
}

