#include "global.h"

int parser(int argc, char*argv[])
{
    map_opt = G_define_standard_option(G_OPT_V_MAP);

    act_opt = G_define_option();
    act_opt->key         = "action";
    act_opt->type        = TYPE_STRING;
    act_opt->required    = YES;
    act_opt->multiple    = NO;
    act_opt->description = _("The edit action to take.");
    act_opt->options     = "create,add,delete,move,merge";

    typ_opt = G_define_standard_option(G_OPT_V_TYPE);
    typ_opt->required    = NO;
    typ_opt->description = _("Select type. Required for add action.");
    typ_opt->options     = "point,line,area,centroid,boundary";
    typ_opt->answer      = "point";
    
    cat_opt = G_define_standard_option(G_OPT_V_CATS);
    cat_opt->required    = NO;
    
    pnt_opt = G_define_option();
    pnt_opt->key         = "coords";
    pnt_opt->key_desc    = "x,y";
    pnt_opt->type        = TYPE_DOUBLE;
    pnt_opt->required    = NO;
    pnt_opt->multiple    = YES;
    pnt_opt->description = _("An x,y list of points. Required for add and move actions.");
    
    val_opt = G_define_option();
    val_opt->key         = "values";
    val_opt->type        = TYPE_STRING;
    val_opt->required    = NO;
    val_opt->multiple    = NO;
    val_opt->description = _("A comma-separated list of attr=val pairs.");

    fld_opt = G_define_standard_option(G_OPT_V_FIELD);

    snp_opt = G_define_option();
    snp_opt->key         = "snap";
    snp_opt->type        = TYPE_DOUBLE;
    snp_opt->required    = NO;
    snp_opt->multiple    = NO;
    snp_opt->description = _("Object points will snap to existing points within snap units.");
    snp_opt->answer      = "5.0";
    
    t_flg = G_define_flag();
    t_flg->key = 't';
    t_flg->description = _("Do not use topology.");

    d_flg = G_define_flag();
    d_flg->key = 'd';
    d_flg->description = _("No database updates.");

    b_flg = G_define_flag();
    b_flg->key = 'b';
    b_flg->description = _("Give cats to boundaries too.");

    c_flg = G_define_flag();
    c_flg->key = 'c';
    c_flg->description = _("Do not close boundaries");

    if(G_parser(argc, argv))
	return 0;

    /* check that the given arguments makes sense together*/
/** @todo check for incorrect extra parameters */

    if(strcmp(act_opt->answer, "create")==0) { /* create requires nothing extra*/
	action_mode = MODE_CREATE;
	return 1;
    }
    
    snap = atof(snp_opt->answer);
    
    if(strcmp(act_opt->answer, "add")==0) { /* add requires a points argument */
	action_mode = MODE_ADD;
	if(pnt_opt->answers == NULL) {
	    help(_("Required parameter <points> not set"));
	    return 0;
	};
	return 1;
    }
    else if(strcmp(act_opt->answer, "delete")==0) { /* del requires a cats */
	action_mode = MODE_DEL;
	if(cat_opt->answers == NULL) {
	    help(_("Required parameter <cats> not set"));
	    return 0;
	};
	return 1;
    }
    else if(strcmp(act_opt->answer, "move")==0) { /* move requires points and cats arguments */
	action_mode = MODE_ADD;
	if((pnt_opt->answers == NULL)||(cat_opt->answers == NULL)) {
	    help(_("Both parameters <points> and <cats> are required."));
	    return 0;
	};
	return 1;
    }
    else if(strcmp(act_opt->answer, "merge")==0) { /* merge requires a cats argument */
	action_mode = MODE_ADD;
	if(cat_opt->answers == NULL) {
	    help(_("Required parameter <cats> not set"));
	    return 0;
	};
	return 1;
    }
    else {
	help(_("This should never happen."));
	return 0;
    }
}

void help(const char *msg)
{
    G_message("\nERROR: %s\n\n", msg);
    G_usage();
}
