#if !defined(_GPDATA_H)
#define _GPDATA_H

int isValidAtomicNumber(int atomicNumber);
const char* gpdata_get_element_name(int atomicNumber);
const char* gpdata_get_element_symbol(int atomicNumber);
const char* gpdata_get_element_weight(int atomicNumber);
const char* gpdata_get_element_density(int atomicNumber);
const char* gpdata_get_element_melting_point(int atomicNumber);
const char* gpdata_get_element_boiling_point(int atomicNumber);
const char* gpdata_get_element_atomic_radius(int atomicNumber);
const char* gpdata_get_element_covalent_radius(int atomicNumber);
const char* gpdata_get_element_ionic_radius(int atomicNumber);
const char* gpdata_get_element_atomic_volume(int atomicNumber);
const char* gpdata_get_element_specific_heat(int atomicNumber);
const char* gpdata_get_element_fusion_heat(int atomicNumber);
const char* gpdata_get_element_evaporation_heat(int atomicNumber);
const char* gpdata_get_termal_conductivity(int atomicNumber);
const char* gpdata_get_element_pauling(int atomicNumber);
const char* gpdata_get_element_energy(int atomicNumber);
const char* gpdata_get_element_oxidation(int atomicNumber);
const char* gpdata_get_element_configuration(int atomicNumber);
int gpdata_get_element_x_position(int atomicNumber);
int gpdata_get_element_y_position(int atomicNumber);
int gpdata_get_element_pixel_depth(int atomicNumber);
int gpdata_get_element_red(int atomicNumber);
int gpdata_get_element_blue(int atomicNumber);
int gpdata_get_element_green(int atomicNumber);


#endif // !defined(_GPDATA_H)
