/*
 *  Copyright (C) 2004 Morten Fjord-Larsen
 *  Copyright (C) 2005 Kouji TAKAO <kouji@netlab.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "helper.h"
#include "application.h"
#include "welcome.h"

GType
gpass_welcome_get_type(void)
{
    static GType type = 0;
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof(GPassWelcomeClass),
            NULL,
            NULL,
            NULL,
            NULL,
            NULL,
            sizeof(GPassWelcome),
            0,
            NULL,
        };
        type = g_type_register_static(GPASS_TYPE_VIEW, "GPassWelcomeType",
                                      &info, 0);
    }
    return type;
}

static void
cancel(GPassWelcome *self)
{
    GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_FAILED;
    gpass_view_shutdown_main_loop(GPASS_VIEW(self));
}
     
gboolean
gpass_welcome_on_cancel(GtkWidget *page, GtkWidget *widget,
                        gpointer user_data)
{
    GPassWelcome *self;
    
    gpass_view_self_from_widget(widget, (gpointer **) &self);
    cancel(self);
    return FALSE;
}

static gboolean
validate_password(GPassWelcome *self)
{
    GtkWidget *password_entry, *verify_entry;
    const gchar *password, *verify;
    
    password_entry = glade_xml_get_widget(GPASS_VIEW(self)->xml, "password");
    password = gtk_entry_get_text(GTK_ENTRY(password_entry));
    verify_entry = glade_xml_get_widget(GPASS_VIEW(self)->xml, "verify");
    verify = gtk_entry_get_text(GTK_ENTRY(verify_entry));
    if (strlen(password) == 0) {
        gpass_view_show_error_message(GPASS_VIEW(self),
                                      _("Empty passwords not allowed!"),
                                      password_entry);
    }
    else if (strcmp(password, verify) != 0) {
        gpass_view_show_error_message
            (GPASS_VIEW(self),
             _("The entered passwords do not match!"),
             password_entry);
    }
    else {
        return TRUE;
    }
    return FALSE;
}

gboolean
gpass_welcome_on_password_page_next(GtkWidget *page, GtkWidget *widget,
                                    gpointer user_data)
{
    GPassWelcome *self;
    
    gpass_view_self_from_widget(widget, (gpointer **) &self);
    return !validate_password(self);
}

void
gpass_welcome_on_finish(GtkWidget *page, GtkWidget *widget,
                        gpointer user_data)
{
    GPassWelcome *self;
    GPassApplication *app;
    GtkWidget *entry;
    const gchar *password;
    GError *error = NULL;
    
    gpass_view_self_from_widget(widget, (gpointer **) &self);
    entry = glade_xml_get_widget(GPASS_VIEW(self)->xml, "password");
    password = gtk_entry_get_text(GTK_ENTRY(entry));
    app = GPASS_APPLICATION(GPASS_VIEW(self)->model);
    error = gpass_file_create(app->file_path, password);
    if (error != NULL) {
        gpass_helper_error(error);
    }
    error = gpass_file_open(&app->file, app->file_path, password);
    GPASS_VIEW(self)->result = GPASS_VIEW_RESULT_SUCCEED;
    gpass_view_shutdown_main_loop(GPASS_VIEW(self));
}

gboolean
gpass_welcome_on_delete_event(GtkWidget *widget, GdkEvent *event,
                              gpointer user_data)
{
    GPassWelcome *self;

    gpass_view_self_from_widget(widget, (gpointer **) &self);
    cancel(self);
    return TRUE;
}
