#!/usr/bin/env python
#
#

__copyright__ = 'this file is in the public domain'
__revision__ = '$Id: setup.py 71 2005-11-10 13:37:50Z bart $'

from setuptools import setup

setup(
    name='gozerbot',
    version='0.9.1.3',
    url='http://gozerbot.org',
    author='Bart Thate',
    author_email='bthate@gmail.com',
    description='the irc bot and jabber bot in one',
    license='BSD',
    scripts = ['bin/gozerbot', 'bin/gozerbot-init', 'bin/gozerbot-start', 'bin/gozerbot-stop', 'bin/gozerbot-upgrade', 'bin/gozerbot-udp', 'bin/gozerbot-install', 'bin/gozerbot-nest', 'bin/gozerbot-exec', 'bin/gozerbot-test'],
    packages=['gozerbot', 'gozerbot.contrib','gozerbot.rest', \
'gozerbot.persist', 'gozerbot.utils', 'gozerbot.irc', \
'gozerbot.plugs', 'gozerbot.compat', 'gozerbot.threads', 'gozerbot.database', \
'gozerbot.xmpp'],
    install_requires = ['sqlalchemy >= 0.5.0',
        'pytz >= 1.0',
        'simplejson >= 1.0',
        'feedparser >= 1.0',
        'pydns >=  2.3.3'],
    long_description = """
GOZERBOT is a channel bot that aids with conversation in irc channels
and jabber conference rooms. its mainly used to send notifications (RSS,
nagios, etc.) and to have custom commands made for the channel. More then 
just a channel bot GOZERBOT aims to provide a platform for the user to 
program his own bot and make it into something thats usefull. This is done 
with a plugin structure that makes it easy to program your own plugins. 
But GOZERBOT comes with some batteries included, there are now over 100 
plugins already written and ready for use.
""",
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: Unix',
        'Programming Language :: Python',
        'Topic :: Communications :: Chat :: Internet Relay Chat',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
)
