# tests/test_event.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, time, Queue

plugins.reload('gozerplugs.plugs', 'event')
queue = Queue.Queue()

class test_event(unittest.TestCase):
    b = Bot('testbot')
    b.userhosts['test'] = 'test@test'
    
    def setUp(self):
        self.b.send = self.sendoverload

    def sendoverload(self, txt):
        queue.put(txt)

    def test_eventadd(self):
        result = self.b.test('event-add')
        self.assert_(stringinlist('<descr>', result))

    def test_eventadd2(self):
        result = self.b.test('event-add mekker')
        self.b.test('event-del 0')
        self.assert_(stringinlist('added', result))

    def test_eventlist(self):
        self.b.test('event-add mekker')
        result = self.b.test('event-list')
        self.b.test('event-del 0')
        self.assert_(stringinlist('mekker', result))

    def test_eventlist2(self):
        result = self.b.test('event-list')
        self.assert_(stringinlist('no events', result))

    def test_eventdel(self):
        result = self.b.test('event-del')
        self.assert_(stringinlist('eventnr', result))

    def test_eventdel2(self):
        result = self.b.test('event-del mekker')
        self.assert_(stringinlist('eventnr', result))

    def test_eventdel3(self):
        result = self.b.test('event-del 8000')
        self.assert_(stringinlist("can't delete", result))

    def test_eventdel4(self):
        self.b.test('event-add mekker')
        result = self.b.test('event-del 0')
        self.assert_(stringinlist('deleted', result))

    def test_eventjoin(self):
        result = self.b.test('event-join')
        self.assert_(stringinlist("<eventnr>", result))

    def test_eventjoin2(self):
        result = self.b.test('event-join mekker')
        self.assert_(stringinlist("<eventnr>", result))

    def test_eventjoin3(self):
        self.b.test('event-add mekker')
        self.b.test('event-join 0')
        result = self.b.test('event-join 0')
        self.b.test('event-del 0')
        self.assert_(stringinlist("already joined", result))

    def test_eventjoin4(self):
        self.b.test('event-add mekker')
        result = self.b.test('event-join 0')
        self.b.test('event-del 0')
        self.assert_(stringinlist("added to", result))

    def test_eventpart(self):
        result = self.b.test('event-part')
        self.assert_(stringinlist("<eventnr>", result))

    def test_eventpart2(self):
        result = self.b.test('event-part mekker')
        self.assert_(stringinlist("<eventnr>", result))

    def test_eventpart3(self):
        self.b.test('event-add mekker')
        self.b.test('event-join 0')
        result = self.b.test('event-part 0')
        self.b.test('event-del 0')
        self.assert_(stringinlist("removed from", result))

    def test_eventwho(self):
        result = self.b.test('event-who')
        self.assert_(stringinlist("<eventnr>", result))

    def test_eventwho2(self):
        result = self.b.test('event-who mekker')
        self.assert_(stringinlist("<eventnr>", result))

    def test_eventwho3(self):
        self.b.test('event-add mekker')
        self.b.test('event-join 0')
        result = self.b.test('event-who 0')
        self.b.test('event-del 0')
        self.assert_(stringinlist("test", result))

    def test_eventremove(self):
        result = self.b.test('event-remove')
        self.assert_(stringinlist("<eventnr> <nick>", result))

    def test_eventremove2(self):
        result = self.b.test('event-remove mekker miep')
        self.assert_(stringinlist("<eventnr> <nick>", result))

    def test_eventremove3(self):
        result = self.b.test('event-remove 0 miep')
        self.assert_(stringinlist("can't remove", result))

    def test_eventremove4(self):
        self.b.test('event-add mekker')
        self.b.test('event-join 0')
        result = self.b.test('event-remove 0 test')
        self.b.test('event-del 0')
        self.assert_(stringinlist("removed", result))

    def test_eventtopic(self):
        result = self.b.test('event-topic', kw = {'channel': 'bla'})
        self.assert_(stringinlist("no events", result))

    def test_eventtopic2(self):
        result = self.b.test('event-topic', 10)
        self.assert_(stringinlist("no events", result))

    def test_eventtopic3(self):
        self.b.test('event-add mekker')
        self.b.test('event-topic')
        result = waitforqueue(queue, 10)
        self.b.test('event-del 0')
        self.assert_(stringinlist('mekker', result))
