# plugs/infoitem.py
#
#

""" information items .. keyword/description pairs """

__copyright__ = 'this file is in the public domain'

from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.redispatcher import rebefore, reafter
from gozerbot.ignore import shouldignore
from gozerbot.datadir import datadir
from gozerbot.persist import Persist
from gozerbot.generic import lockdec, cchar
from gozerbot.aliases import aliases
from gozerbot.plughelp import plughelp
from gozerbot.callbacks import callbacks
from gozerbot.users import users
from gozerbot.config import config
if config['dbenable']:
    from gozerbot.db import db
import thread, os, time

plughelp.add('infoitem', 'also known as factoids .. info can be retrieved \
by keyword or searched')

infolock = thread.allocate_lock()

# create lock descriptor
locked = lockdec(infolock)

class Infoitems(Persist):

    """ information items """

    @locked
    def add(self, item, issue, userhost=None, ttime=None):
        """ add an item """
        item = item.lower()
        if self.data.has_key(item):
            if not issue in self.data[item]:
                self.data[item].append(issue)
        else:
            self.data[item] = [issue]
        self.save()

    @locked
    def addnosave(self, item, issue, userhost=None, ttime=None):
        """ add item but don't save """
        item = item.lower()
        if self.data.has_key(item):
            self.data[item].append(issue)
        else:
            self.data[item] = [issue]

    @locked
    def deltxt(self, item, txt):
        """ delete todo item with txt in it """
        got = 0
        if not self.data.has_key(item):
            return got
        for i in range(len(self.data[item])-1, -1, -1):
            if txt in self.data[item][i]:
                del self.data[item][i]
                got += 1
                break
        if got:
            self.save()
        return got

    @locked
    def delete(self, item, itemnr):
        """ delete item with nr from list """
        try:
            del self.data[item.lower()][int(itemnr)]
            self.save()
            return 1
        except IndexError:
            return 0
        except ValueError:
            return 0
        except KeyError:
            return 0

    def get(self, item):
        """ get description of item """
        if self.data.has_key(item):
            return self.data[item]

    def size(self):
        """ return number of items """
        return len(self.data)

    def searchdescr(self, txt):
        result = []
        for i, j in self.data.iteritems():
            for z in j:
                if txt in z:
                    result.append((i, z))
        return result

    def searchitem(self, txt):
        result = []
        for i, j in self.data.iteritems():
            if txt in i:
                result.append((i, j))
        return result

class InfoitemsDb(object):

    """ information items """
 
    def add(self, item, description, userhost, ttime):
        """ add an item """
        item = item.lower()
        result = db.execute(""" INSERT INTO infoitems(item, description, \
userhost, time) VALUES(%s, %s, %s, %s) """, (item, description, \
userhost, ttime))
        return result

    def get(self, item):
        """ get infoitems """
        item = item.lower()
        result = db.execute(""" SELECT description FROM \
infoitems WHERE item = %s """, item)
        res = []
        if result:
            for i in result:
                res.append(i[0])
        return res

    def delete(self, indexnr):
        """ delete item with indexnr  """
        result = db.execute(""" DELETE FROM infoitems WHERE indx = %s """, \
indexnr)
        return result

    def deltxt(self, item, txt):
        """ delete item with matching txt """
        result = db.execute(""" DELETE FROM infoitems WHERE item = %s AND \
description LIKE %s """, (item, '%%%s%%' % txt))
        return result

    def size(self):
        """ return number of items """
        result = db.execute(""" SELECT COUNT(*) FROM infoitems """)
        return result[0][0]

    def searchitem(self, search):
        """ search items """
        result = db.execute(""" SELECT item, description \
FROM infoitems WHERE item LIKE %s """, '%%%s%%' % search)
        return result

    def searchdescr(self, search):
        """ search descriptions """
        result = db.execute(""" SELECT item, description \
FROM infoitems WHERE description LIKE %s """, '%%%s%%' % search)
        return result

if config['dbenable']:
    info = InfoitemsDb()
else:
    info = Infoitems(datadir + os.sep + 'infoitems')
    if not info.data:
        info.data = {}
assert(info)

def size():
    """ return number of infoitems """
    return info.size()

def infopre(bot, ievent):
    """ see if info callback needs to be called """
    cc = cchar(bot, ievent)
    if ievent.origtxt and cc == ievent.origtxt[0] and not ievent.usercmnd \
and ievent.txt:
        return 1

def infocb(bot, ievent):
    """ implement a !infoitem callback """
    if not shouldignore(ievent.userhost) and \
users.allowed(ievent.userhost, 'USER'):
        data = info.get(ievent.txt)
        if data:
            ievent.reply('%s is ' % ievent.txt, data , dot=True)

callbacks.add('PRIVMSG', infocb, infopre)

def handle_infosize(bot, ievent):
    """ info-size .. show number of information items """
    ievent.reply("we have %s infoitems" % info.size())

cmnds.add('info-size', handle_infosize, ['USER', 'WEB', 'ANON'])
examples.add('info-size', 'show number of infoitems', 'info-size')

def handle_addinfoitem(bot, ievent):
    """ <keyword> = <description> .. add information item """
    try:
        (what, description) = ievent.groups
    except ValueError:
        ievent.reply('i need <item> <description>')
        return
    if len(description) < 3:
        ievent.reply('i need at least 3 chars for the description')
        return
    what = what.strip()
    info.add(what, description, ievent.userhost, time.time())
    ievent.reply('item added')

rebefore.add(10, '^(.+?)\s+=\s+(.+)$', handle_addinfoitem, ['USER', \
'INFOADD'], allowqueue=False)
examples.add('=', 'add description to item', 'dunk = top')

def handle_question(bot, ievent):
    """ <keyword>? .. ask for information item description """
    try:
        what = ievent.groups[0]
    except IndexError:
        ievent.reply('i need a argument')
        return
    what = what.strip().lower()
    infoitems = info.get(what)
    if infoitems:
        ievent.reply("%s is " % what, infoitems, dot=True)
    else:
        ievent.reply('nothing known about %s' % what)
        return

reafter.add(10, '^(.+)\?$', handle_question, ['USER', 'WEB', 'JCOLL', \
'ANON'], allowqueue=True)
reafter.add(10, '^\?(.+)$', handle_question, ['USER', 'WEB', 'JCOLL', \
'ANON'], allowqueue=True)
examples.add('?', 'show infoitems of <what>', '1) test? 2) ?test')

def handle_forget(bot, ievent):
    """ forget <keyword> <txttomatch> .. remove information item where \
        description matches txt given """
    if len(ievent.args) > 1:
        what = ' '.join(ievent.args[:-1])
        txt = ievent.args[-1]
    else:
        ievent.missing('<item> <txttomatch> (min 3 chars)')
        return
    if len(txt) < 3:
        ievent.reply('i need txt with at least 3 characters')
        return
    what = what.strip().lower()
    try:
        nrtimes = info.deltxt(what, txt)
    except KeyError:
        ievent.reply('no records matching %s found' % what)
        return
    if nrtimes:
        ievent.reply('item deleted')
    else:
        ievent.reply('delete %s of %s failed' % (txt, what))

cmnds.add('info-forget', handle_forget, ['FORGET', 'OPER'])
examples.add('info-forget', 'forget <item> containing <txt>', 'info-forget \
dunk bla')
aliases.data['forget'] = 'info-forget'

def handle_searchdescr(bot, ievent):
    """ info-sd <txttosearchfor> .. search information items descriptions """
    if not ievent.rest:
        ievent.missing('<txt>')
        return
    else:
        what = ievent.rest
    what = what.strip().lower()
    result = info.searchdescr(what)
    if result: 
        res = []
        for i in result:
            res.append("[%s] %s" % (i[0], i[1]))
        ievent.reply("the following matches %s: " % what, res, dot=True)
    else:
        ievent.reply('none found')

cmnds.add('info-sd', handle_searchdescr, ['USER', 'WEB', 'ANON'])
examples.add('info-sd', 'info-sd <txt> ..  search description of \
infoitems', 'info-sd http')
aliases.data['sd'] = 'info-sd'
aliases.data['sl'] = 'info-sd'

def handle_searchitem(bot, ievent):
    """ info-si <txt> .. search information keywords """
    if not ievent.rest:
        ievent.missing('<txt>')
        return
    else:
        what = ievent.rest
    what = what.strip().lower()
    result = info.searchitem(what)
    if result:
        res = []
        for i in result:
            res.append("[%s] %s" % (i[0], i[1]))
        ievent.reply("the following matches %s: " % what, res, dot=True)
    else:
        ievent.reply('none found')

cmnds.add('info-si', handle_searchitem, ['USER', 'WEB', 'ANON'])
examples.add('info-si', 'info-si <txt> ..  search the infoitems keys', \
'info-si test')
aliases.data['si'] = 'info-si'
