# tests/test_dns.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist
from gozerbot.plugins import plugins
import unittest

plugins.reload('gozerplugs.plugs', 'dns')

class test_dns(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.channels['#test'] = {}
    
    def test_host(self):
        result = self.b.test('host')
        self.assert_(stringinlist('<ipnr>', result))

    def test_host2(self):
        result = self.b.test('host 213.196.7.1159')
        self.assert_(stringinlist("can't match", result))

    def test_host3(self):
        result = self.b.test('host 213.196.7.59')
        self.assert_(stringinlist('gozerbot.org', result))

    def test_ip(self):
        result = self.b.test('ip')
        self.assert_(stringinlist('<hostname>', result))

    def test_ip2(self):
        result = self.b.test('ip mekker.mip.klaas')
        self.assert_(stringinlist("can't match", result))

    def test_ip3(self):
        result = self.b.test('host 213.196.7.59')
        self.assert_(stringinlist('gozerbot.org', result))
