;;; utils.scm: common utility procedures
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
;;; 
;;; utils.scm should be automatically loaded thru init.scm

(define (list2asv li any) 
  "convert list to any separated vector"
  (if (=(length li) 1)
      (car li)
      (string-append (car li) any (list2csv (cdr li)))))

(define (list2csv li) 
  "convert list to comma separated vector"
  (list2asv li ", "))

(define (send-message-to-group group message)
  "send message to group"
  (for-each (lambda (buddy)
	      (gy-send-message-no-hook buddy message))
	    group))

(define (local-date-time)
  (string-append
                 (strftime "%a" (localtime (current-time)))
		 " "
                 (strftime "%b" (localtime (current-time)))
		 " "
                 (strftime "%e" (localtime (current-time)))
		 " "
                 (strftime "%T" (localtime (current-time)))
		 " "
                 (strftime "%Z" (localtime (current-time)))
		 " "
                 (strftime "%Y" (localtime (current-time)))))

