/*
     This file is part of GNUnet.
     (C) 2007, 2008 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/status.h
 * @brief status codes for files
 * @author Christian Grothoff
 */

#ifndef FS_STATUS_H
#define FS_STATUS_H

#include "platform.h"
#include <GNUnet/gnunet_uritrack_lib.h>
#include "status.h"

const char *getColorCode (enum GNUNET_URITRACK_STATE state);

const char *getStatusName (enum GNUNET_URITRACK_STATE state);

GdkPixbuf *getStatusLogo (enum GNUNET_URITRACK_STATE state);

#endif
