#ifndef MP3_CONTROL_H
#define MP3_CONTROL_H

#include "gnomp3.h"
#include "mp3list.h"

struct mp3_control{
    MP3 *mp3;
    GList *next_playlist_song; /* may not be equal to mp3->next if the
				* currently playing mp3 is not from the
				* song list. */
    char *time;
    double progress; /* the amount of song played [ from 0.0 to 1.0 ] */
    int playing; /* flag to indicate of the next song should be loaded when the
		  * current one finishes */
    int paused;
    int bitrate, freq;
    int update_seek; /* flag to indicate if the seek/progress bar of the
		      * mp3player should be updated. It is not to be up
		      * when the user holds down a mouse button on it */
};

extern struct mp3_control mp3_control_state;

void mp3_control_play(MP3 *mp3, float pos);
void mp3_control_update_display();
void mp3_control_play_next();
void mp3_control_play_prev();
void mp3_control_stop();
void mp3_control_play_nth(int num);
void mp3_control_play_selected();
void mp3_control_play_selected_song(GtkWidget *w, gpointer data);
void mp3_control_play_cb();
void mp3_control_next_cb();
void mp3_control_seek_press(GtkWidget *w, gpointer data);
void mp3_control_seek_release(GtkWidget *w, gpointer data);
void mp3_control_pause_cb();

#endif
