/* SqliteDatabase.c generated by valac, the Vala compiler
 * generated from SqliteDatabase.vala, do not modify */

/*
 * Copyright (C) 2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE (dvb_database_sqlite_sqlite_database_get_type ())
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabase))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_IS_SQLITE_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE))
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabaseClass))

typedef struct _DVBdatabasesqliteSqliteDatabase DVBdatabasesqliteSqliteDatabase;
typedef struct _DVBdatabasesqliteSqliteDatabaseClass DVBdatabasesqliteSqliteDatabaseClass;
typedef struct _DVBdatabasesqliteSqliteDatabasePrivate DVBdatabasesqliteSqliteDatabasePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabasesqliteSqliteDatabase {
	GObject parent_instance;
	DVBdatabasesqliteSqliteDatabasePrivate * priv;
	sqlite3* db;
};

struct _DVBdatabasesqliteSqliteDatabaseClass {
	GObjectClass parent_class;
	void (*create) (DVBdatabasesqliteSqliteDatabase* self, GError** error);
	void (*upgrade) (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
	void (*on_open) (DVBdatabasesqliteSqliteDatabase* self);
};

struct _DVBdatabasesqliteSqliteDatabasePrivate {
	GFile* _database_file;
	gint new_version;
};


static gpointer dvb_database_sqlite_sqlite_database_parent_class = NULL;

GType dvb_database_sqlite_sqlite_database_get_type (void);
GQuark dvb_database_sql_error_quark (void);
#define DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_DATABASE_SQLITE_TYPE_SQLITE_DATABASE, DVBdatabasesqliteSqliteDatabasePrivate))
enum  {
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_DUMMY_PROPERTY,
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE
};
DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version);
GFile* dvb_database_sqlite_sqlite_database_get_database_file (DVBdatabasesqliteSqliteDatabase* self);
void dvb_utils_mkdirs (GFile* directory, GError** error);
void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const char* errmsg, GError** error);
gint dvb_database_sqlite_sqlite_database_get_version (DVBdatabasesqliteSqliteDatabase* self);
void dvb_database_sqlite_sqlite_database_create (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
void dvb_database_sqlite_sqlite_database_set_version (DVBdatabasesqliteSqliteDatabase* self, gint version);
void dvb_database_sqlite_sqlite_database_set_journal_mode (DVBdatabasesqliteSqliteDatabase* self);
void dvb_database_sqlite_sqlite_database_on_open (DVBdatabasesqliteSqliteDatabase* self);
void dvb_database_sqlite_sqlite_database_open (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const char* sql, GError** error);
gint dvb_database_sqlite_sqlite_database_simple_query_int (DVBdatabasesqliteSqliteDatabase* self, const char* sql, GError** error);
void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error);
static void dvb_database_sqlite_sqlite_database_real_create (DVBdatabasesqliteSqliteDatabase* self, GError** error);
static void dvb_database_sqlite_sqlite_database_real_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error);
static void dvb_database_sqlite_sqlite_database_real_on_open (DVBdatabasesqliteSqliteDatabase* self);
static void dvb_database_sqlite_sqlite_database_set_database_file (DVBdatabasesqliteSqliteDatabase* self, GFile* value);
static void dvb_database_sqlite_sqlite_database_finalize (GObject* obj);
static void dvb_database_sqlite_sqlite_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_database_sqlite_sqlite_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DVBdatabasesqliteSqliteDatabase* dvb_database_sqlite_sqlite_database_construct (GType object_type, GFile* dbfile, gint version) {
	DVBdatabasesqliteSqliteDatabase * self;
	g_return_val_if_fail (dbfile != NULL, NULL);
	self = (DVBdatabasesqliteSqliteDatabase*) g_object_new (object_type, "database-file", dbfile, NULL);
	self->priv->new_version = version;
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_database_sqlite_sqlite_database_open (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	GError * _inner_error_;
	GFile* dbfile;
	gboolean create_tables;
	GFile* dbfile_dir;
	sqlite3* _tmp3_;
	gint _tmp2_;
	sqlite3* _tmp1_ = NULL;
	char* _tmp0_;
	gboolean _tmp4_;
	gint version;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->db != NULL) {
		return;
	}
	dbfile = _g_object_ref0 (self->priv->_database_file);
	create_tables = !g_file_query_exists (dbfile, NULL);
	dbfile_dir = g_file_get_parent (dbfile);
	if (!g_file_query_exists (dbfile_dir, NULL)) {
		{
			dvb_utils_mkdirs (dbfile_dir, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("SqliteDatabase.vala:51: Could not create directory: %s", e->message);
				_g_error_free0 (e);
				_g_object_unref0 (dbfile);
				_g_object_unref0 (dbfile_dir);
				return;
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (dbfile);
				_g_object_unref0 (dbfile_dir);
				return;
			} else {
				_g_object_unref0 (dbfile);
				_g_object_unref0 (dbfile_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	if ((_tmp4_ = (_tmp2_ = sqlite3_open (_tmp0_ = g_file_get_path (dbfile), &_tmp1_), self->db = (_tmp3_ = _tmp1_, _sqlite3_close0 (self->db), _tmp3_), _tmp2_) != SQLITE_OK, _g_free0 (_tmp0_), _tmp4_)) {
		dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (dbfile);
				_g_object_unref0 (dbfile_dir);
				return;
			} else {
				_g_object_unref0 (dbfile);
				_g_object_unref0 (dbfile_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	version = dvb_database_sqlite_sqlite_database_get_version (self);
	if (create_tables) {
		g_debug ("SqliteDatabase.vala:63: Creating tables");
		dvb_database_sqlite_sqlite_database_create (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (dbfile);
				_g_object_unref0 (dbfile_dir);
				return;
			} else {
				_g_object_unref0 (dbfile);
				_g_object_unref0 (dbfile_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	} else {
		if (self->priv->new_version > version) {
			g_debug ("SqliteDatabase.vala:66: Updating tables");
			dvb_database_sqlite_sqlite_database_upgrade (self, version, self->priv->new_version, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (dbfile);
					_g_object_unref0 (dbfile_dir);
					return;
				} else {
					_g_object_unref0 (dbfile);
					_g_object_unref0 (dbfile_dir);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
	dvb_database_sqlite_sqlite_database_set_version (self, self->priv->new_version);
	dvb_database_sqlite_sqlite_database_set_journal_mode (self);
	dvb_database_sqlite_sqlite_database_on_open (self);
	_g_object_unref0 (dbfile);
	_g_object_unref0 (dbfile_dir);
}


void dvb_database_sqlite_sqlite_database_set_version (DVBdatabasesqliteSqliteDatabase* self, gint version) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		dvb_database_sqlite_sqlite_database_exec_sql (self, _tmp0_ = g_strdup_printf ("PRAGMA user_version = %d", version), &_inner_error_);
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch1_dvb_database_sql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("SqliteDatabase.vala:82: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void dvb_database_sqlite_sqlite_database_set_journal_mode (DVBdatabasesqliteSqliteDatabase* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	{
		dvb_database_sqlite_sqlite_database_exec_sql (self, "PRAGMA journal_mode = TRUNCATE", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch2_dvb_database_sql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("SqliteDatabase.vala:90: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gint dvb_database_sqlite_sqlite_database_get_version (DVBdatabasesqliteSqliteDatabase* self) {
	gint result = 0;
	GError * _inner_error_;
	gint version;
	g_return_val_if_fail (self != NULL, 0);
	_inner_error_ = NULL;
	version = 0;
	{
		gint _tmp0_;
		_tmp0_ = dvb_database_sqlite_sqlite_database_simple_query_int (self, "PRAGMA user_version", &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch3_dvb_database_sql_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		version = _tmp0_;
	}
	goto __finally3;
	__catch3_dvb_database_sql_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("SqliteDatabase.vala:102: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = version;
	return result;
}


gint dvb_database_sqlite_sqlite_database_simple_query_int (DVBdatabasesqliteSqliteDatabase* self, const char* sql, GError** error) {
	gint result = 0;
	GError * _inner_error_;
	sqlite3_stmt* st;
	sqlite3_stmt* _tmp1_;
	sqlite3_stmt* _tmp0_ = NULL;
	gint ret;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_inner_error_ = NULL;
	st = NULL;
	sqlite3_prepare (self->db, sql, -1, &_tmp0_, NULL);
	st = (_tmp1_ = _tmp0_, _sqlite3_finalize0 (st), _tmp1_);
	ret = 0;
	if (sqlite3_step (st) == SQLITE_ROW) {
		ret = sqlite3_column_int (st, 0);
	} else {
		dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (st);
				return 0;
			} else {
				_sqlite3_finalize0 (st);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = ret;
	_sqlite3_finalize0 (st);
	return result;
}


void dvb_database_sqlite_sqlite_database_exec_sql (DVBdatabasesqliteSqliteDatabase* self, const char* sql, GError** error) {
	GError * _inner_error_;
	char* errmsg;
	char* _tmp2_;
	gint _tmp1_;
	char* _tmp0_ = NULL;
	gint val;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sql != NULL);
	_inner_error_ = NULL;
	errmsg = NULL;
	val = (_tmp1_ = sqlite3_exec (self->db, sql, NULL, NULL, &_tmp0_), errmsg = (_tmp2_ = _tmp0_, _g_free0 (errmsg), _tmp2_), _tmp1_);
	if (val != SQLITE_OK) {
		dvb_database_sqlite_sqlite_database_throw_last_error (self, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (errmsg);
				return;
			} else {
				_g_free0 (errmsg);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_g_free0 (errmsg);
}


void dvb_database_sqlite_sqlite_database_begin_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	dvb_database_sqlite_sqlite_database_exec_sql (self, "BEGIN;", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_database_sqlite_sqlite_database_end_transaction (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	dvb_database_sqlite_sqlite_database_exec_sql (self, "END;", &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void dvb_database_sqlite_sqlite_database_throw_last_error (DVBdatabasesqliteSqliteDatabase* self, const char* errmsg, GError** error) {
	GError * _inner_error_;
	gint code;
	char* msg;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	code = sqlite3_errcode (self->db);
	msg = NULL;
	if (errmsg == NULL) {
		char* _tmp0_;
		msg = (_tmp0_ = g_strdup_printf ("SqlError: %d: %s", code, sqlite3_errmsg (self->db)), _g_free0 (msg), _tmp0_);
	} else {
		char* _tmp1_;
		msg = (_tmp1_ = g_strdup (errmsg), _g_free0 (msg), _tmp1_);
	}
	switch (code) {
		case 1:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_ERROR, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 2:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_INTERNAL, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 3:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_PERM, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 4:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_ABORT, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 5:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_BUSY, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 6:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_LOCKED, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 7:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOMEM, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 8:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_READONLY, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 9:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_INTERRUPT, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 10:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_IOERR, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 11:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_CORRUPT, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 12:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOTFOUND, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 13:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_FULL, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 14:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_CANTOPEN, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 15:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_PROTOCOL, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 16:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_EMPTY, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 17:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_SCHEMA, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 18:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_TOOBIG, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 19:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_CONSTRAINT, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 20:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_MISMATCH, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 21:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_MISUSE, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 22:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOLFS, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 23:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_AUTH, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 24:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_FORMAT, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 25:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_RANGE, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		case 26:
		{
			_inner_error_ = g_error_new_literal (DVB_DATABASE_SQL_ERROR, DVB_DATABASE_SQL_ERROR_NOTADB, msg);
			{
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					return;
				} else {
					_g_free0 (msg);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
		default:
		{
			break;
		}
	}
	_g_free0 (msg);
}


static void dvb_database_sqlite_sqlite_database_real_create (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_database_sqlite_sqlite_database_create'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_database_sqlite_sqlite_database_create (DVBdatabasesqliteSqliteDatabase* self, GError** error) {
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS (self)->create (self, error);
}


static void dvb_database_sqlite_sqlite_database_real_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_database_sqlite_sqlite_database_upgrade'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_database_sqlite_sqlite_database_upgrade (DVBdatabasesqliteSqliteDatabase* self, gint old_version, gint new_version, GError** error) {
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS (self)->upgrade (self, old_version, new_version, error);
}


static void dvb_database_sqlite_sqlite_database_real_on_open (DVBdatabasesqliteSqliteDatabase* self) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `dvb_database_sqlite_sqlite_database_on_open'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void dvb_database_sqlite_sqlite_database_on_open (DVBdatabasesqliteSqliteDatabase* self) {
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_CLASS (self)->on_open (self);
}


GFile* dvb_database_sqlite_sqlite_database_get_database_file (DVBdatabasesqliteSqliteDatabase* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_database_file;
	return result;
}


static void dvb_database_sqlite_sqlite_database_set_database_file (DVBdatabasesqliteSqliteDatabase* self, GFile* value) {
	GFile* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_database_file = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_database_file), _tmp0_);
	g_object_notify ((GObject *) self, "database-file");
}


static void dvb_database_sqlite_sqlite_database_class_init (DVBdatabasesqliteSqliteDatabaseClass * klass) {
	dvb_database_sqlite_sqlite_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBdatabasesqliteSqliteDatabasePrivate));
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->create = dvb_database_sqlite_sqlite_database_real_create;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->upgrade = dvb_database_sqlite_sqlite_database_real_upgrade;
	DVB_DATABASE_SQLITE_SQLITE_DATABASE_CLASS (klass)->on_open = dvb_database_sqlite_sqlite_database_real_on_open;
	G_OBJECT_CLASS (klass)->get_property = dvb_database_sqlite_sqlite_database_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_database_sqlite_sqlite_database_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_database_sqlite_sqlite_database_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE, g_param_spec_object ("database-file", "database-file", "database-file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_database_sqlite_sqlite_database_instance_init (DVBdatabasesqliteSqliteDatabase * self) {
	self->priv = DVB_DATABASE_SQLITE_SQLITE_DATABASE_GET_PRIVATE (self);
}


static void dvb_database_sqlite_sqlite_database_finalize (GObject* obj) {
	DVBdatabasesqliteSqliteDatabase * self;
	self = DVB_DATABASE_SQLITE_SQLITE_DATABASE (obj);
	_g_object_unref0 (self->priv->_database_file);
	_sqlite3_close0 (self->db);
	G_OBJECT_CLASS (dvb_database_sqlite_sqlite_database_parent_class)->finalize (obj);
}


GType dvb_database_sqlite_sqlite_database_get_type (void) {
	static volatile gsize dvb_database_sqlite_sqlite_database_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_database_sqlite_sqlite_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBdatabasesqliteSqliteDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_database_sqlite_sqlite_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBdatabasesqliteSqliteDatabase), 0, (GInstanceInitFunc) dvb_database_sqlite_sqlite_database_instance_init, NULL };
		GType dvb_database_sqlite_sqlite_database_type_id;
		dvb_database_sqlite_sqlite_database_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBdatabasesqliteSqliteDatabase", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&dvb_database_sqlite_sqlite_database_type_id__volatile, dvb_database_sqlite_sqlite_database_type_id);
	}
	return dvb_database_sqlite_sqlite_database_type_id__volatile;
}


static void dvb_database_sqlite_sqlite_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBdatabasesqliteSqliteDatabase * self;
	self = DVB_DATABASE_SQLITE_SQLITE_DATABASE (object);
	switch (property_id) {
		case DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE:
		g_value_set_object (value, dvb_database_sqlite_sqlite_database_get_database_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_database_sqlite_sqlite_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBdatabasesqliteSqliteDatabase * self;
	self = DVB_DATABASE_SQLITE_SQLITE_DATABASE (object);
	switch (property_id) {
		case DVB_DATABASE_SQLITE_SQLITE_DATABASE_DATABASE_FILE:
		dvb_database_sqlite_sqlite_database_set_database_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




