/* TerrestrialChannel.c generated by valac, the Vala compiler
 * generated from TerrestrialChannel.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>


#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
typedef struct _DVBChannelPrivate DVBChannelPrivate;

#define DVB_TYPE_TERRESTRIAL_CHANNEL (dvb_terrestrial_channel_get_type ())
#define DVB_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannel))
#define DVB_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))
#define DVB_IS_TERRESTRIAL_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_IS_TERRESTRIAL_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TERRESTRIAL_CHANNEL))
#define DVB_TERRESTRIAL_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelClass))

typedef struct _DVBTerrestrialChannel DVBTerrestrialChannel;
typedef struct _DVBTerrestrialChannelClass DVBTerrestrialChannelClass;
typedef struct _DVBTerrestrialChannelPrivate DVBTerrestrialChannelPrivate;

#define DVB_TYPE_DVB_SRC_INVERSION (dvb_dvb_src_inversion_get_type ())

#define DVB_TYPE_DVB_SRC_BANDWIDTH (dvb_dvb_src_bandwidth_get_type ())

#define DVB_TYPE_DVB_SRC_CODE_RATE (dvb_dvb_src_code_rate_get_type ())

#define DVB_TYPE_DVB_SRC_MODULATION (dvb_dvb_src_modulation_get_type ())

#define DVB_TYPE_DVB_SRC_TRANSMISSION_MODE (dvb_dvb_src_transmission_mode_get_type ())

#define DVB_TYPE_DVB_SRC_GUARD (dvb_dvb_src_guard_get_type ())

#define DVB_TYPE_DVB_SRC_HIERARCHY (dvb_dvb_src_hierarchy_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBChannel {
	GObject parent_instance;
	DVBChannelPrivate * priv;
};

struct _DVBChannelClass {
	GObjectClass parent_class;
	gboolean (*is_valid) (DVBChannel* self);
	gboolean (*on_same_transport_stream) (DVBChannel* self, DVBChannel* channel);
	gboolean (*equals) (DVBChannel* self, DVBChannel* channel);
	void (*setup_dvb_source) (DVBChannel* self, GstElement* source);
	char* (*to_string) (DVBChannel* self);
};

struct _DVBTerrestrialChannel {
	DVBChannel parent_instance;
	DVBTerrestrialChannelPrivate * priv;
};

struct _DVBTerrestrialChannelClass {
	DVBChannelClass parent_class;
};

typedef enum  {
	DVB_DVB_SRC_INVERSION_INVERSION_OFF,
	DVB_DVB_SRC_INVERSION_INVERSION_ON,
	DVB_DVB_SRC_INVERSION_INVERSION_AUTO
} DVBDvbSrcInversion;

typedef enum  {
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_8_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_7_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_6_MHZ,
	DVB_DVB_SRC_BANDWIDTH_BANDWIDTH_AUTO
} DVBDvbSrcBandwidth;

typedef enum  {
	DVB_DVB_SRC_CODE_RATE_FEC_NONE,
	DVB_DVB_SRC_CODE_RATE_FEC_1_2,
	DVB_DVB_SRC_CODE_RATE_FEC_2_3,
	DVB_DVB_SRC_CODE_RATE_FEC_3_4,
	DVB_DVB_SRC_CODE_RATE_FEC_4_5,
	DVB_DVB_SRC_CODE_RATE_FEC_5_6,
	DVB_DVB_SRC_CODE_RATE_FEC_6_7,
	DVB_DVB_SRC_CODE_RATE_FEC_7_8,
	DVB_DVB_SRC_CODE_RATE_FEC_8_9,
	DVB_DVB_SRC_CODE_RATE_FEC_AUTO
} DVBDvbSrcCodeRate;

typedef enum  {
	DVB_DVB_SRC_MODULATION_QPSK,
	DVB_DVB_SRC_MODULATION_QAM_16,
	DVB_DVB_SRC_MODULATION_QAM_32,
	DVB_DVB_SRC_MODULATION_QAM_64,
	DVB_DVB_SRC_MODULATION_QAM_128,
	DVB_DVB_SRC_MODULATION_QAM_256,
	DVB_DVB_SRC_MODULATION_QAM_AUTO
} DVBDvbSrcModulation;

typedef enum  {
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_2K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_8K,
	DVB_DVB_SRC_TRANSMISSION_MODE_TRANSMISSION_MODE_AUTO
} DVBDvbSrcTransmissionMode;

typedef enum  {
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_32,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_16,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_8,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_1_4,
	DVB_DVB_SRC_GUARD_GUARD_INTERVAL_AUTO
} DVBDvbSrcGuard;

typedef enum  {
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_NONE,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_1,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_2,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_4,
	DVB_DVB_SRC_HIERARCHY_HIERARCHY_AUTO
} DVBDvbSrcHierarchy;

struct _DVBTerrestrialChannelPrivate {
	DVBDvbSrcInversion _Inversion;
	DVBDvbSrcBandwidth _Bandwidth;
	DVBDvbSrcCodeRate _CodeRateHP;
	DVBDvbSrcCodeRate _CodeRateLP;
	DVBDvbSrcModulation _Constellation;
	DVBDvbSrcTransmissionMode _TransmissionMode;
	DVBDvbSrcGuard _GuardInterval;
	DVBDvbSrcHierarchy _Hierarchy;
};


static gpointer dvb_terrestrial_channel_parent_class = NULL;

GType dvb_channel_get_type (void);
GType dvb_terrestrial_channel_get_type (void);
GType dvb_dvb_src_inversion_get_type (void);
GType dvb_dvb_src_bandwidth_get_type (void);
GType dvb_dvb_src_code_rate_get_type (void);
GType dvb_dvb_src_modulation_get_type (void);
GType dvb_dvb_src_transmission_mode_get_type (void);
GType dvb_dvb_src_guard_get_type (void);
GType dvb_dvb_src_hierarchy_get_type (void);
#define DVB_TERRESTRIAL_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_TERRESTRIAL_CHANNEL, DVBTerrestrialChannelPrivate))
enum  {
	DVB_TERRESTRIAL_CHANNEL_DUMMY_PROPERTY,
	DVB_TERRESTRIAL_CHANNEL_INVERSION,
	DVB_TERRESTRIAL_CHANNEL_BANDWIDTH,
	DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP,
	DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP,
	DVB_TERRESTRIAL_CHANNEL_CONSTELLATION,
	DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE,
	DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL,
	DVB_TERRESTRIAL_CHANNEL_HIERARCHY
};
DVBChannel* dvb_channel_construct_without_schedule (GType object_type);
DVBTerrestrialChannel* dvb_terrestrial_channel_new_without_schedule (void);
DVBTerrestrialChannel* dvb_terrestrial_channel_construct_without_schedule (GType object_type);
DVBDvbSrcModulation dvb_terrestrial_channel_get_Constellation (DVBTerrestrialChannel* self);
DVBDvbSrcTransmissionMode dvb_terrestrial_channel_get_TransmissionMode (DVBTerrestrialChannel* self);
DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateHP (DVBTerrestrialChannel* self);
DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateLP (DVBTerrestrialChannel* self);
DVBDvbSrcGuard dvb_terrestrial_channel_get_GuardInterval (DVBTerrestrialChannel* self);
DVBDvbSrcBandwidth dvb_terrestrial_channel_get_Bandwidth (DVBTerrestrialChannel* self);
guint dvb_channel_get_Frequency (DVBChannel* self);
DVBDvbSrcHierarchy dvb_terrestrial_channel_get_Hierarchy (DVBTerrestrialChannel* self);
DVBDvbSrcInversion dvb_terrestrial_channel_get_Inversion (DVBTerrestrialChannel* self);
static void dvb_terrestrial_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source);
const char* dvb_channel_get_Name (DVBChannel* self);
const char* dvb_utils_get_nick_from_enum (GType enumtype, gint val);
guint dvb_channel_get_VideoPID (DVBChannel* self);
char* dvb_channel_get_audio_pids_string (DVBChannel* self);
guint dvb_channel_get_Sid (DVBChannel* self);
static char* dvb_terrestrial_channel_real_to_string (DVBChannel* base);
DVBChannel* dvb_channel_construct (GType object_type);
DVBTerrestrialChannel* dvb_terrestrial_channel_new (void);
DVBTerrestrialChannel* dvb_terrestrial_channel_construct (GType object_type);
void dvb_terrestrial_channel_set_Inversion (DVBTerrestrialChannel* self, DVBDvbSrcInversion value);
void dvb_terrestrial_channel_set_Bandwidth (DVBTerrestrialChannel* self, DVBDvbSrcBandwidth value);
void dvb_terrestrial_channel_set_CodeRateHP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_CodeRateLP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value);
void dvb_terrestrial_channel_set_Constellation (DVBTerrestrialChannel* self, DVBDvbSrcModulation value);
void dvb_terrestrial_channel_set_TransmissionMode (DVBTerrestrialChannel* self, DVBDvbSrcTransmissionMode value);
void dvb_terrestrial_channel_set_GuardInterval (DVBTerrestrialChannel* self, DVBDvbSrcGuard value);
void dvb_terrestrial_channel_set_Hierarchy (DVBTerrestrialChannel* self, DVBDvbSrcHierarchy value);
static void dvb_terrestrial_channel_finalize (GObject* obj);
static void dvb_terrestrial_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_terrestrial_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DVBTerrestrialChannel* dvb_terrestrial_channel_construct_without_schedule (GType object_type) {
	DVBTerrestrialChannel * self;
	self = (DVBTerrestrialChannel*) dvb_channel_construct_without_schedule (object_type);
	return self;
}


DVBTerrestrialChannel* dvb_terrestrial_channel_new_without_schedule (void) {
	return dvb_terrestrial_channel_construct_without_schedule (DVB_TYPE_TERRESTRIAL_CHANNEL);
}


static void dvb_terrestrial_channel_real_setup_dvb_source (DVBChannel* base, GstElement* source) {
	DVBTerrestrialChannel * self;
	self = (DVBTerrestrialChannel*) base;
	g_return_if_fail (source != NULL);
	g_object_set ((GObject*) source, "modulation", self->priv->_Constellation, NULL);
	g_object_set ((GObject*) source, "trans-mode", self->priv->_TransmissionMode, NULL);
	g_object_set ((GObject*) source, "code-rate-hp", self->priv->_CodeRateHP, NULL);
	g_object_set ((GObject*) source, "code-rate-lp", self->priv->_CodeRateLP, NULL);
	g_object_set ((GObject*) source, "guard", self->priv->_GuardInterval, NULL);
	g_object_set ((GObject*) source, "bandwidth", self->priv->_Bandwidth, NULL);
	g_object_set ((GObject*) source, "frequency", dvb_channel_get_Frequency ((DVBChannel*) self), NULL);
	g_object_set ((GObject*) source, "hierarchy", self->priv->_Hierarchy, NULL);
	g_object_set ((GObject*) source, "inversion", self->priv->_Inversion, NULL);
}


static char* dvb_terrestrial_channel_real_to_string (DVBChannel* base) {
	DVBTerrestrialChannel * self;
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	self = (DVBTerrestrialChannel*) base;
	result = (_tmp1_ = g_strdup_printf ("%s:%u:%s:%s:%s:%s:%s:%s:%s:%s:%u:%s:%u", dvb_channel_get_Name (DVB_CHANNEL (self)), dvb_channel_get_Frequency (DVB_CHANNEL (self)), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_INVERSION, (gint) self->priv->_Inversion), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_BANDWIDTH, (gint) self->priv->_Bandwidth), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) self->priv->_CodeRateHP), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) self->priv->_CodeRateLP), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_MODULATION, (gint) self->priv->_Constellation), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, (gint) self->priv->_TransmissionMode), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_GUARD, (gint) self->priv->_GuardInterval), dvb_utils_get_nick_from_enum (DVB_TYPE_DVB_SRC_HIERARCHY, (gint) self->priv->_Hierarchy), dvb_channel_get_VideoPID (DVB_CHANNEL (self)), _tmp0_ = dvb_channel_get_audio_pids_string (DVB_CHANNEL (self)), dvb_channel_get_Sid (DVB_CHANNEL (self))), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


DVBTerrestrialChannel* dvb_terrestrial_channel_construct (GType object_type) {
	DVBTerrestrialChannel * self;
	self = (DVBTerrestrialChannel*) dvb_channel_construct (object_type);
	return self;
}


DVBTerrestrialChannel* dvb_terrestrial_channel_new (void) {
	return dvb_terrestrial_channel_construct (DVB_TYPE_TERRESTRIAL_CHANNEL);
}


DVBDvbSrcInversion dvb_terrestrial_channel_get_Inversion (DVBTerrestrialChannel* self) {
	DVBDvbSrcInversion result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Inversion;
	return result;
}


void dvb_terrestrial_channel_set_Inversion (DVBTerrestrialChannel* self, DVBDvbSrcInversion value) {
	g_return_if_fail (self != NULL);
	self->priv->_Inversion = value;
	g_object_notify ((GObject *) self, "Inversion");
}


DVBDvbSrcBandwidth dvb_terrestrial_channel_get_Bandwidth (DVBTerrestrialChannel* self) {
	DVBDvbSrcBandwidth result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Bandwidth;
	return result;
}


void dvb_terrestrial_channel_set_Bandwidth (DVBTerrestrialChannel* self, DVBDvbSrcBandwidth value) {
	g_return_if_fail (self != NULL);
	self->priv->_Bandwidth = value;
	g_object_notify ((GObject *) self, "Bandwidth");
}


DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateHP (DVBTerrestrialChannel* self) {
	DVBDvbSrcCodeRate result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_CodeRateHP;
	return result;
}


void dvb_terrestrial_channel_set_CodeRateHP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value) {
	g_return_if_fail (self != NULL);
	self->priv->_CodeRateHP = value;
	g_object_notify ((GObject *) self, "CodeRateHP");
}


DVBDvbSrcCodeRate dvb_terrestrial_channel_get_CodeRateLP (DVBTerrestrialChannel* self) {
	DVBDvbSrcCodeRate result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_CodeRateLP;
	return result;
}


void dvb_terrestrial_channel_set_CodeRateLP (DVBTerrestrialChannel* self, DVBDvbSrcCodeRate value) {
	g_return_if_fail (self != NULL);
	self->priv->_CodeRateLP = value;
	g_object_notify ((GObject *) self, "CodeRateLP");
}


DVBDvbSrcModulation dvb_terrestrial_channel_get_Constellation (DVBTerrestrialChannel* self) {
	DVBDvbSrcModulation result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Constellation;
	return result;
}


void dvb_terrestrial_channel_set_Constellation (DVBTerrestrialChannel* self, DVBDvbSrcModulation value) {
	g_return_if_fail (self != NULL);
	self->priv->_Constellation = value;
	g_object_notify ((GObject *) self, "Constellation");
}


DVBDvbSrcTransmissionMode dvb_terrestrial_channel_get_TransmissionMode (DVBTerrestrialChannel* self) {
	DVBDvbSrcTransmissionMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_TransmissionMode;
	return result;
}


void dvb_terrestrial_channel_set_TransmissionMode (DVBTerrestrialChannel* self, DVBDvbSrcTransmissionMode value) {
	g_return_if_fail (self != NULL);
	self->priv->_TransmissionMode = value;
	g_object_notify ((GObject *) self, "TransmissionMode");
}


DVBDvbSrcGuard dvb_terrestrial_channel_get_GuardInterval (DVBTerrestrialChannel* self) {
	DVBDvbSrcGuard result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_GuardInterval;
	return result;
}


void dvb_terrestrial_channel_set_GuardInterval (DVBTerrestrialChannel* self, DVBDvbSrcGuard value) {
	g_return_if_fail (self != NULL);
	self->priv->_GuardInterval = value;
	g_object_notify ((GObject *) self, "GuardInterval");
}


DVBDvbSrcHierarchy dvb_terrestrial_channel_get_Hierarchy (DVBTerrestrialChannel* self) {
	DVBDvbSrcHierarchy result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_Hierarchy;
	return result;
}


void dvb_terrestrial_channel_set_Hierarchy (DVBTerrestrialChannel* self, DVBDvbSrcHierarchy value) {
	g_return_if_fail (self != NULL);
	self->priv->_Hierarchy = value;
	g_object_notify ((GObject *) self, "Hierarchy");
}


static void dvb_terrestrial_channel_class_init (DVBTerrestrialChannelClass * klass) {
	dvb_terrestrial_channel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBTerrestrialChannelPrivate));
	DVB_CHANNEL_CLASS (klass)->setup_dvb_source = dvb_terrestrial_channel_real_setup_dvb_source;
	DVB_CHANNEL_CLASS (klass)->to_string = dvb_terrestrial_channel_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = dvb_terrestrial_channel_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_terrestrial_channel_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_terrestrial_channel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_INVERSION, g_param_spec_enum ("Inversion", "Inversion", "Inversion", DVB_TYPE_DVB_SRC_INVERSION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_BANDWIDTH, g_param_spec_enum ("Bandwidth", "Bandwidth", "Bandwidth", DVB_TYPE_DVB_SRC_BANDWIDTH, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP, g_param_spec_enum ("CodeRateHP", "CodeRateHP", "CodeRateHP", DVB_TYPE_DVB_SRC_CODE_RATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP, g_param_spec_enum ("CodeRateLP", "CodeRateLP", "CodeRateLP", DVB_TYPE_DVB_SRC_CODE_RATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_CONSTELLATION, g_param_spec_enum ("Constellation", "Constellation", "Constellation", DVB_TYPE_DVB_SRC_MODULATION, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE, g_param_spec_enum ("TransmissionMode", "TransmissionMode", "TransmissionMode", DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL, g_param_spec_enum ("GuardInterval", "GuardInterval", "GuardInterval", DVB_TYPE_DVB_SRC_GUARD, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_TERRESTRIAL_CHANNEL_HIERARCHY, g_param_spec_enum ("Hierarchy", "Hierarchy", "Hierarchy", DVB_TYPE_DVB_SRC_HIERARCHY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_terrestrial_channel_instance_init (DVBTerrestrialChannel * self) {
	self->priv = DVB_TERRESTRIAL_CHANNEL_GET_PRIVATE (self);
}


static void dvb_terrestrial_channel_finalize (GObject* obj) {
	DVBTerrestrialChannel * self;
	self = DVB_TERRESTRIAL_CHANNEL (obj);
	G_OBJECT_CLASS (dvb_terrestrial_channel_parent_class)->finalize (obj);
}


GType dvb_terrestrial_channel_get_type (void) {
	static volatile gsize dvb_terrestrial_channel_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_terrestrial_channel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTerrestrialChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_terrestrial_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTerrestrialChannel), 0, (GInstanceInitFunc) dvb_terrestrial_channel_instance_init, NULL };
		GType dvb_terrestrial_channel_type_id;
		dvb_terrestrial_channel_type_id = g_type_register_static (DVB_TYPE_CHANNEL, "DVBTerrestrialChannel", &g_define_type_info, 0);
		g_once_init_leave (&dvb_terrestrial_channel_type_id__volatile, dvb_terrestrial_channel_type_id);
	}
	return dvb_terrestrial_channel_type_id__volatile;
}


static void dvb_terrestrial_channel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBTerrestrialChannel * self;
	self = DVB_TERRESTRIAL_CHANNEL (object);
	switch (property_id) {
		case DVB_TERRESTRIAL_CHANNEL_INVERSION:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Inversion (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_BANDWIDTH:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Bandwidth (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP:
		g_value_set_enum (value, dvb_terrestrial_channel_get_CodeRateHP (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP:
		g_value_set_enum (value, dvb_terrestrial_channel_get_CodeRateLP (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CONSTELLATION:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Constellation (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE:
		g_value_set_enum (value, dvb_terrestrial_channel_get_TransmissionMode (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL:
		g_value_set_enum (value, dvb_terrestrial_channel_get_GuardInterval (self));
		break;
		case DVB_TERRESTRIAL_CHANNEL_HIERARCHY:
		g_value_set_enum (value, dvb_terrestrial_channel_get_Hierarchy (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_terrestrial_channel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBTerrestrialChannel * self;
	self = DVB_TERRESTRIAL_CHANNEL (object);
	switch (property_id) {
		case DVB_TERRESTRIAL_CHANNEL_INVERSION:
		dvb_terrestrial_channel_set_Inversion (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_BANDWIDTH:
		dvb_terrestrial_channel_set_Bandwidth (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_HP:
		dvb_terrestrial_channel_set_CodeRateHP (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CODE_RATE_LP:
		dvb_terrestrial_channel_set_CodeRateLP (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_CONSTELLATION:
		dvb_terrestrial_channel_set_Constellation (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_TRANSMISSION_MODE:
		dvb_terrestrial_channel_set_TransmissionMode (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_GUARD_INTERVAL:
		dvb_terrestrial_channel_set_GuardInterval (self, g_value_get_enum (value));
		break;
		case DVB_TERRESTRIAL_CHANNEL_HIERARCHY:
		dvb_terrestrial_channel_set_Hierarchy (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




