/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include "gnome-cmd-includes.h"


/******************************************************************************
*
*   Function: get_password
*
*   Purpose: Shows a dialog where the user can enter a passord and also
*            offers him the possibility to store the password for the rest of
*            the session.
*
*   Params: none
*
*   Returns: A string containing the password or NULL if the user bailed out.
*
*   Statuses: 
*
******************************************************************************/
static gchar*
get_password (void)
{	
	gint ret;
	gchar *pw = NULL;
	GtkWidget *dialog;
	GtkWidget *prompt_label;
	GtkWidget *pw_entry;
	GtkWidget *remember_check;
	
	dialog = gnome_dialog_new (
		"CVS Password dialog",
		GNOME_STOCK_BUTTON_OK,
		GNOME_STOCK_BUTTON_CANCEL,
		NULL);
	
	prompt_label = gtk_label_new ("Enter your cvs password");
	gtk_widget_show (prompt_label);
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), prompt_label,
						TRUE, TRUE, 1);

	pw_entry = gtk_entry_new ();
	gtk_entry_set_visibility (GTK_ENTRY (pw_entry), FALSE);
	gtk_widget_show (pw_entry);
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), pw_entry,
						TRUE, TRUE, 1);

	remember_check = gtk_check_button_new_with_label (
		"Remember password this session");
	gtk_widget_show (remember_check);
	gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), remember_check,
						TRUE, TRUE, 1);

	ret = gnome_dialog_run (GNOME_DIALOG (dialog));

	if (ret == 0)
	{
		/* OK */
		pw = gtk_entry_get_text (GTK_ENTRY (pw_entry));
		if (gtk_toggle_button_get_active (
				GTK_TOGGLE_BUTTON (remember_check)))
			cvs_session_set_password (pw);
	}

	gtk_widget_hide (dialog);

	return pw;
}


/******************************************************************************
*
*   Function: gnome_cmd_cvs_password_get
*
*   Purpose: Get the cvs password from the user. If a stored one exists use that
*            otherwise ask for a new.
*
*   Params: none
*
*   Returns: A string containing the password or NULL if the user bailed out.
*            The string should be freed after use.
*
*   Statuses: 
*
******************************************************************************/
gchar *
gnome_cmd_cvs_password_get (void)
{
	gchar *pw = cvs_session_get_password ();
	if (!pw)
		pw = get_password ();
	return pw;
}


