/*
    GNOME Commander - A GNOME based file manager 
    Copyright (C) 2001-2002 Marcus Bjurman

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 
#include <glib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pty.h>
#include <errno.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <string.h>

#include "cvs-session.h"
#include "gnome-cmd-includes.h"

//#define CVS_PATH "/usr/bin/cvs"
#define CVS_PATH "/home/opum/dev/unixprogs/readpw/readpw"
#define CVS_PROG "readpw"
#define CVS_MAX_ARGS 255

static gchar *cvs_password = NULL;
static gchar *cvs_dir = NULL;

static gchar *cvs_argv[CVS_MAX_ARGS+1];

/*
static void
cvs_run_command (char **argv, gboolean logging_in, CvsOutputCallback func, gpointer data)
{
	gint i = -1;
	g_printerr ("===== args =====\n");
	while (argv[++i] != NULL)
		g_printerr ("argv[%d] = %s\n", i, cvs_argv[i]);		
}
*/


static void
cvs_run_command (char **argv, gboolean logging_in, CvsOutputCallback func, gpointer data)
{
	pid_t pid;
	int master;
	gchar *pw = NULL;

	if (gnome_cmd_data_get_cvs_over_ssh () || logging_in) {
		pw = gnome_cmd_cvs_password_get ();
		if (pw == NULL) {
			g_printerr ("Password not set\n");
			return;
		}
	}

	/*
	g_printerr ("dir: %s\n", cvs_dir);
	g_printerr ("root: %s\n", gnome_cmd_data_get_cvsroot ());
	return;
	*/

	chdir (cvs_dir);
	setenv ("CVS_ROOT", gnome_cmd_data_get_cvsroot (), 1);
	
	pid = forkpty (&master, NULL, NULL, NULL);
	
	if (pid == 0) {
		/* child */
		execv (CVS_PATH, argv);		
	}	
	else if (pid > 0) {
		/* parent */
		char buf[1024];

		/* get password if using ssh or if logging in */
		if (gnome_cmd_data_get_cvs_over_ssh () || logging_in) {
			
			if (read (master, buf, 1024) > 0)
				fprintf (stderr, "readthis: %s\n", buf);
		
			if (write (master, "secret\n", 8) != 8)
				perror ("Failed to write to tty1");
			
			//if (write (master, "\n", 1) != 1)
				//perror ("Failed to write to tty2");
		}

		errno = 0;
		while (read (master, buf, 1024) > 0) {
			printf ("readthis later: \"%s\"\n", buf);
			if (func)
				func (data, buf);
		}
		perror ("cvs_run_command error");
		
		waitpid (pid, NULL, 0);
	}
	else {
		perror ("Child fork error");
		exit (1);
	}
}


static gchar **create_argv1 (gchar *arg1)
{
	cvs_argv[0] = CVS_PROG;
	cvs_argv[1] = arg1;
	cvs_argv[2] = NULL;

	return cvs_argv;
}


static gchar **create_argv2 (gchar *arg1, gchar *arg2)
{
	cvs_argv[0] = CVS_PROG;
	cvs_argv[1] = arg1;
	cvs_argv[2] = arg2;
	cvs_argv[3] = NULL;

	return cvs_argv;
}


static gchar **create_argvlist (gchar *arg1, gchar *comment, GList *list)
{
	gint i = 0, j;
	gint len = g_list_length (list);
	GList *tmp = list;
	
	cvs_argv[i++] = CVS_PROG;
	cvs_argv[i++] = arg1;

	if (comment) {
		cvs_argv[i++] = "-m";
		cvs_argv[i++] = comment;
	}

	if (len > CVS_MAX_ARGS)
		len = CVS_MAX_ARGS;

	for ( j=0 ; j<len ; j++ ) {
		cvs_argv[i++] = tmp->data;
		tmp = tmp->next;
	}

	cvs_argv[i] = NULL;

	return cvs_argv;
}


void
cvs_session_set_password (gchar *pw)
{
	if (cvs_password)
		g_free (cvs_password);

	cvs_password = pw;
}


gchar *
cvs_session_get_password (void)
{
	return cvs_password;
}


void cvs_session_setdir (gchar *dir)
{
	cvs_dir = dir;
}


void cvs_session_login     (void)
{
	cvs_run_command (create_argv1 ("login"), TRUE, NULL, NULL);
}


void cvs_session_logout    (void)
{
	cvs_run_command (create_argv1 ("logout"), FALSE, NULL, NULL);
}


void cvs_session_log       (gchar *file, CvsOutputCallback func, gpointer data)
{
	cvs_run_command (create_argv2 ("log", file), FALSE, func, data);
}


void cvs_session_diff      (gchar *file, CvsOutputCallback func, gpointer data)
{
	cvs_run_command (create_argv2 ("diff", file), FALSE, func, data);
}


void cvs_session_add       (GList *files)
{
	cvs_run_command (create_argvlist ("add", NULL, files), FALSE, NULL, NULL);
}


void cvs_session_remove    (GList *files)
{
	cvs_run_command (create_argvlist ("remove", NULL, files), FALSE, NULL, NULL);
}


void cvs_session_commit    (GList *files, gchar *comment,
							CvsOutputCallback func, gpointer data)
{
	cvs_run_command (create_argvlist ("commit", comment, files), FALSE, func, data);
}


void cvs_session_update    (GList *files, CvsOutputCallback func, gpointer data)
{
	cvs_run_command (create_argvlist ("update", NULL, files), FALSE, func, data);
}


void cvs_session_import    (gchar *modulename, gchar *vendortag, gchar *comment,
							CvsOutputCallback func, gpointer data)
{
	GList *list = NULL;

	list = g_list_append (list, modulename);
	list = g_list_append (list, vendortag);
	list = g_list_append (list, "start");
	
	cvs_run_command (create_argvlist ("import", comment, list), FALSE, func, data);

	g_list_free (list);
}


void cvs_session_checkout  (gchar *modulename, CvsOutputCallback func, gpointer data)
{
	cvs_argv[0] = "cvs";
	cvs_argv[1] = "checkout";
	cvs_argv[2] = modulename;
	cvs_argv[3] = NULL;

	cvs_run_command (cvs_argv, FALSE, func, data);
}


