#ifndef _MACRO_H
#define _MACRO_H 1

#define NUMMACROS	12

struct macro {
	gchar name[16];
	gchar *text;
};

extern void macroconfig_load(void);

extern void macroconfig(gint n);
extern void macroconfig_clear(void);
extern void macroconfig_close(gboolean save);
extern void macroconfig_delete(void);

extern void send_macro(gint n);

extern void push_button(const gchar *name);

extern void send_char(const gchar c);
extern void send_string(gchar *str);

/* ---------------------------------------------------------------------- */

#define MACRODEF1NAME	"CQ"
#define	MACRODEF1TEXT	"\
$tx
cq cq cq de $mycall $mycall $mycall
cq cq cq de $mycall $mycall $mycall
cq cq cq de $mycall $mycall $mycall

($utcdate $utctime)

pse k
$rx"

/* ---------------------------------------------------------------------- */

#define MACRODEF2NAME	"Station"
#define MACRODEF2TEXT	"\
---
$mycall station info:

Name:   $myname
QTH:    $myqth, Locator: $myloc
Email:  $myemail
Rig:    Icom IC-745
Pwr:    abt 20 W
Ant:    end fed wire + SG-237 automatic ATU
Comp:   Pentium 200 MHz 64 MB
OS:     RedHat Linux 6.2
Soft:   $soft

localtime: $time ($utctime)

---
"

/* ---------------------------------------------------------------------- */

#define MACRODEF3NAME	"BTU"
#define MACRODEF3TEXT	"\
btu $call de $mycall k
$rx"

#define MACRODEF4NAME	"call de mycall"
#define MACRODEF4TEXT   "\
$tx
$call de $mycall
"

/* ---------------------------------------------------------------------- */

#define MACRODEF5NAME	"QRZ ?"
#define MACRODEF5TEXT	"\
$tx
qrz? qrz? qrz? de $mycall $mycall $mycall

pse kn
$rx"

/* ---------------------------------------------------------------------- */

#define MACRODEF6NAME	"73 & sk"
#define MACRODEF6TEXT	"\
Thanks for very nice MFSK QSO dr $name.
QSL is ok via buro if needed.
73 and hope to see you soon again on MFSK, my favorite digital mode.
$call de $mycall
sk sk
$rx "

/* ---------------------------------------------------------------------- */

#define MACRODEF7NAME	""
#define MACRODEF7TEXT	""

/* ---------------------------------------------------------------------- */

#define MACRODEF8NAME	""
#define MACRODEF8TEXT	""

/* ---------------------------------------------------------------------- */

#define MACRODEF9NAME	""
#define MACRODEF9TEXT	""

/* ---------------------------------------------------------------------- */

#define MACRODEF10NAME	""
#define MACRODEF10TEXT	""

/* ---------------------------------------------------------------------- */

#define MACRODEF11NAME	""
#define MACRODEF11TEXT	""

/* ---------------------------------------------------------------------- */

#define MACRODEF12NAME	""
#define MACRODEF12TEXT	""

/* ---------------------------------------------------------------------- */

#endif
