# $Id: gjots2.spec,v 1.10 2004/11/30 08:41:34 bhepple Exp $

#   Copyright (C) 2002 Robert Hepple 
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License as
#   published by the Free Software Foundation; either version 2 of the
#   License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
#   MA 02111-1307, USA.

%define ver 2.1.1
%define rel 1
%define prefix /usr

Summary: A note jotter. Organise your ideas, notes, facts in a hierarchy.
Name: gjots2
Version: %{ver}
Release: %{rel}
URL: http://bhepple.freeshell.org/gjots
#Source: http://bhepple.freeshell.org/gjots/gjots2-%{ver}.tar.gz
Source0: %{name}-%{version}.tgz
License: GPL
Group: Applications/Productivity
BuildRoot: %{_tmppath}/root-%{name}-%{version}
Prefix: %{_prefix}
BuildArch: noarch

Requires: python >= 2.3, pygtk2 >= 2.4.1, gnome-python2 >= 2.0.2
Requires: libglade2 >= 2.4

%description

gjots2 ("gee-jots" or, if you prefer, "gyachts"!) is a way to marshall
and organise your text notes in a convenient, hierachical way. I use
it for all my notes on Unix, my personal bits and pieces, recipes and
even PINs and passwords (encrypted with ccrypt(1)).

You can also use it to "mind-map" your compositions - write down all
your thoughts and then start to organise them into a tree. By
manipulating the tree you can easily reorder your thoughts and
structure them appropriately.

This is a Python/GTK-2 version of the original gjots program by the same author.

%prep
%setup
%build
%install

# typically:
#	buildroot=/var/tmp/root-gjots2-2.1.1
#	_datadir=/usr/share
#	_bindir=/usr/bin
#	_libdir=/usr/lib

%{__rm} -rf %{buildroot}
%{__install} -d -m0755  \
                        %{buildroot}%{_datadir}/applications \
                        %{buildroot}%{_datadir}/%{name} \
                        %{buildroot}%{_datadir}/pixmaps \
                        %{buildroot}%{_datadir}/man/man1 \
                        %{buildroot}%{_libdir}/%{name} \
                        %{buildroot}%{_bindir}
%{__install} -m0755 bin/gjots2 bin/gjots2docbook bin/gjots2html bin/docbook2gjots %{buildroot}%{_bindir}/
%{__install} -m0755 lib/*.py %{buildroot}%{_libdir}/%{name}/
%{__install} -m0644 gjots.glade2 %{buildroot}%{_datadir}/%{name}
%{__install} -m0644 gjots.png %{buildroot}%{_datadir}/%{name}
%{__install} -m0644 gjots.png %{buildroot}%{_datadir}/pixmaps/
%{__install} -m0644 gjots2.desktop %{buildroot}%{_datadir}/applications/
%{__install} -m0644 share/man/man1/gjots2.1 %{buildroot}%{_datadir}/man/man1
%{__install} -m0644 share/man/man1/gjots2html.1 %{buildroot}%{_datadir}/man/man1
%{__install} -m0644 share/man/man1/gjots2docbook.1 %{buildroot}%{_datadir}/man/man1
%{__install} -m0644 share/man/man1/docbook2gjots.1 %{buildroot}%{_datadir}/man/man1

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc AUTHORS INSTALL README COPYING ChangeLog gjots2.gjots
/
%changelog
* Sun May 23 2004  <bhepple@freeshell.org>
- Initial build.
#  Version 2.1.0, 22nd Nov 2004

    * New Features:
          o Added "Merge Items"
          o Added "Split Item"
          o Added "Sort" function
          o Added "Print" function
          o Added "Show All" function
          o Added "Hide All" function 
    * Bugs fixed:
    * Known bugs (fixes or ideas appreciated):

# Version 2.0.1, June 2nd 2004

    * New Features:
          o Added setup.py and uninstall.sh for non-RPM, non-emerge systems
          o Reduced python requirement to 2.2 (untested - please confirm if it works for you!) 
    * Bugs fixed:
          o (Bug & fix (thanks!) sent in by Andreas Reimer) gui.py:434: self._warp(newnode) Caused an error message on "New Item", changed it to self._warp(new_child)
          o (Bug & fix (thanks!) sent in by Andreas Reimer) gui.py:1081 was: self.gui.msg("No changes to save"), changed to self.msg("...")
          o (Bug sent in by Andreas Reimer & Thomas Zajic): file.py:228: on write_file() a reference to body[-1] caused an error. changed to: if body and not body[-1] == '\n'
          o (Bug sent in by Thomas Zajic): hard-coded references to "/usr" should be replaced with something more adjustable to allow installation "anywhere". Also added setup.py and uninstall.sh for systems without RPM or emerge. 
    * Known bugs (fixes or ideas appreciated):

# Version 2.0.0, May 22nd 2004

    * New Features:
          o Initial release of gjots2 for Python/GTK-2 
    * Downloads:
          o On RPM-based system:
                + gjots2-2.1.0-1.src.rpm Source RPM - 0 bytes
                + gjots2-2.1.0-1.noarch.rpm Installation RPM - 0 bytes 
          o On Gentoo:
                + gjots2-2.1.0.ebuild - ebuild file - 0 bytes
                + gjots2-2.1.0.tgz - Tarball - 0 bytes 
          o Other systems - use "python ./setup.py install [ --prefix=/usr... ]" from the tarball 



