/* $Header: /cvs/gnome/gIDE/src/gI_window.h,v 1.3 1999/12/04 03:00:24 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GI_WINDOW_H
#define GI_WINDOW_H

#include <gtk/gtk.h>

/*
 * Prototypes for 'gI_window.c'
 */

glong window_destroy( GtkWidget *widget, GdkEvent *event, gI_window *window );
void create_prjftree( gI_window *window );

gI_window *gI_window_new( void );
void gI_window_clear_statusbar( gI_window *window );
void gI_window_set_statusbar( gI_document *document );
void gI_window_switch_notebookpage( GtkWidget *widget, GtkNotebookPage *page, guint page_num, gI_window *window );
void gI_window_set_visible_read_only( gint sensitive );
void gI_window_create_popupmenu(gI_window *window);

void gI_window_drag_recv( GtkWidget *widget, GdkDragContext *context, gint x,
                          gint y, GtkSelectionData *seldata, guint info,
                          guint time, gI_window *window );

#define STATUSBAR_CONTEXT_CURSOR_POSITION 100

#endif

