/*
** 1999-05-02 -	A little color dialog module. Really just a convenience wrapper around
**		the GTK+ GtkColorSelection widget. Saves a few uppercase keystrokes.
** 1999-06-19 -	Adapted for the new dialog module.
*/

#include "gentoo.h"

#include "dialog.h"
#include "color_dialog.h"

typedef struct {
	GtkWidget	*colsel;		/* The core widget. */
	ColChangedFunc	func;
	gpointer	user;
} ColDlg;

/* ----------------------------------------------------------------------------------------- */

/* 1999-05-02 -	This gets called as the user changes color controls in dialog. Call callback. */
static void evt_color_changed(GtkWidget *wid, gpointer user)
{
	ColDlg		*dlg = user;

	if(dlg->func != NULL)
	{
		GdkColor	col;

		gtk_color_selection_get_current_color(GTK_COLOR_SELECTION(dlg->colsel), &col);
		dlg->func(&col, dlg->user);
	}
}

gint cdl_dialog_sync_new_wait(const gchar *label, ColChangedFunc func, const GdkColor *initial, gpointer user)
{
	static ColDlg	dlg;
	Dialog		*d;
	gint		ret = -1;

	dlg.func = func;
	dlg.user = user;

	dlg.colsel = gtk_color_selection_new();
	gtk_color_selection_set_update_policy(GTK_COLOR_SELECTION(dlg.colsel), GTK_UPDATE_CONTINUOUS);
	g_signal_connect(G_OBJECT(dlg.colsel), "color_changed", G_CALLBACK(evt_color_changed), &dlg);
	if(initial != NULL)
		gtk_color_selection_set_current_color(GTK_COLOR_SELECTION(dlg.colsel), initial);
	d = dlg_dialog_sync_new(dlg.colsel, label ? label : _("Edit Color"), NULL);
	ret = dlg_dialog_sync_wait(d);
	dlg_dialog_sync_destroy(d);

	return ret;
}
