/*
** 1998-06-07 -	A command to set the owner and group information on a file
**		(or set of files). Might get GUI-ish.
** 1998-06-08 -	Fixed the userinfo module, which allowed this one to take another
**		step towards completetion; now it preselects the current user/group
**		names from the option menus. I still miss some form of higher-level
**		control widgetry, though. Later...
** 1998-10-16 -	The defaults now work (even if you don't operate the menus).
** 1999-03-06 -	Adapted for new selection/generic/dirrow representations.
** 2000-03-23 -	Now uses combo boxes rather than menus to display user and group
**		lists. Also allows user to type in either number or name of the
**		desired user and/or group directly. All in all, a lot smoother.
** 2001-04-24 -	Added recursion option.
*/

#include "gentoo.h"

#include <ctype.h>
#include <stdlib.h>

#include "dirpane.h"
#include "errors.h"
#include "fileutil.h"
#include "userinfo.h"

#include "cmd_generic.h"
#include "cmd_chown.h"

#define	CMD_ID	"chown"

/* ----------------------------------------------------------------------------------------- */

typedef struct {
	GtkWidget	*combo;
	gint		history;			/* The weirdly named thing (see gtk_option_menu widget). */
} URow;

typedef struct {
	GtkWidget	*vbox;
	GtkWidget	*label;
	GtkWidget	*rowtable;
	URow		row[2];
	guint		user, group;			/* The currently selected IDs. */
	gint		user_index, group_index;	/* Indices to default to. */
	GtkWidget	*recurse;
	gboolean	last_recurse;
} ChoInfo;

/* ----------------------------------------------------------------------------------------- */

static void cho_body(MainInfo *min, DirPane *src, DirRow *row, GtkWindow *win, gpointer user)
{
	gchar	label[MAXNAMLEN + 64];
	ChoInfo	*cho = (ChoInfo *) user;

	gtk_window_set_title(win, _("Change ownership"));
	g_snprintf(label, sizeof label, _("Set Ownership for '%s':"), DP_ROW_NAME(row));
	gtk_label_set_text(GTK_LABEL(cho->label), label);
	gtk_widget_grab_focus(GTK_COMBO(cho->row[0].combo)->entry);
}

/* ----------------------------------------------------------------------------------------- */

static gboolean parse_or_lookup(const gchar *str, long lookup(const gchar *name), long *tmp)
{
	while(isspace((int) *str))
		str++;
	if(isdigit((int) *str))
	{
		gchar	*eptr;

		*tmp = strtol(str, &eptr, 10);
		if(eptr == str)
			return FALSE;
	}
	else
		*tmp = lookup(str);
	return TRUE;
}

static gboolean get_own(ChoInfo *cho, uid_t *owner, gid_t *group)
{
	gchar	*text;
	long	tmp;

	if((text = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cho->row[0].combo)->entry))) == NULL)
		return FALSE;
	if(parse_or_lookup(text, usr_lookup_uid, &tmp))
		*owner = tmp;
	else
		return FALSE;
	if((text = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cho->row[1].combo)->entry))) == NULL)
		return FALSE;
	if(parse_or_lookup(text, usr_lookup_gid, &tmp))
	{
		*group = tmp;
		return TRUE;
	}
	return FALSE;
}

#if 0
static int cho_action(MainInfo *min, DirPane *src, DirPane *dst, DirRow *row, gpointer user)
{
	ChoInfo	*cho = (ChoInfo *) user;
	gchar	*text, namebuf[PATH_MAX];

	err_clear(min);

	g_snprintf(namebuf, sizeof namebuf, "%s/%s", src->dir.path, DP_ROW_NAME(row));

	if((text = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cho->row[0].combo)->entry))) != NULL)
	{
		long	uid;

		errno = EINVAL;

		while(isspace((int) *text))
			text++;
		if(isdigit((int) *text))
			uid = strtol(text, NULL, 0);
		else
			uid = usr_lookup_uid(text);

		if(uid >= 0)
		{
			if((text = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(cho->row[1].combo)->entry))) != NULL)
			{
				long	gid;

				while(isspace((int) *text))
					text++;
				if(isdigit((int) *text))
					gid = strtol(text, NULL, 0);
				else
					gid = usr_lookup_gid(text);

				if(gid >= 0)
				{
					err_clear(min);
					chown(namebuf, uid, gid);
				}
			}
		}
	}
	if(errno)
		err_set(min, errno, CMD_ID, DP_ROW_NAME(row));
	else
		dp_unselect(src, DP_ROW_INDEX(src, row));

	return errno == 0;
}
#endif

static gboolean chown_file(MainInfo *min, const gchar *name, uid_t owner, gid_t group)
{
	if(chown(name, owner, group) != 0)
		err_set(min, errno, CMD_ID, name);
	return errno == 0;
}

static gboolean chown_dir(MainInfo *min, const gchar *name, uid_t owner, gid_t group, gboolean recurse)
{
	if(chown(name, owner, group) == 0 && recurse)
	{
		gchar	old_dir[PATH_MAX];
		DIR	*dir;

		if(!fut_cd(name, old_dir, sizeof old_dir))
			return FALSE;

		if((dir = opendir(".")) != NULL)
		{
			struct dirent	*de;
			struct stat	stat;
			gboolean	ok = TRUE;

			while(!errno && ((de = readdir(dir)) != NULL) && ok)
			{
				if(!min->cfg.dir_filter(de->d_name))
					continue;
				if(lstat(de->d_name, &stat) == 0)
				{
					gchar	buf[PATH_MAX];

					g_snprintf(buf, sizeof buf, "%s%c%s", name, G_DIR_SEPARATOR, de->d_name);
					if(S_ISDIR(stat.st_mode))
						ok = chown_dir(min, de->d_name, owner, group, recurse);
					else
						ok = chown_file(min, de->d_name, owner, group);
				}
			}
			closedir(dir);
		}
		fut_cd(old_dir, NULL, 0U);
	}
	else if(!recurse)
		err_set(min, errno, CMD_ID, name);
	return errno == 0;
}

static int cho_action(MainInfo *min, DirPane *src, DirPane *dst, DirRow *row, gpointer user)
{
	ChoInfo		*cho = user;
	uid_t		owner;
	gid_t		group;
	gboolean	ok;

	if(!fut_cd(src->dir.path, NULL, 0))
		return 0;
	get_own(cho, &owner, &group);
	cho->last_recurse = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cho->recurse));

	if(S_ISDIR(DP_ROW_LSTAT(row).st_mode))
		ok = chown_dir(min,  DP_ROW_NAME(row), owner, group, cho->last_recurse);
	else
		ok = chown_file(min, DP_ROW_NAME(row), owner, group);
	if(ok)
		dp_unselect(src, DP_ROW_INDEX(src, row));
	return errno == 0;
}

/* ----------------------------------------------------------------------------------------- */

int cmd_chown(MainInfo *min, DirPane *src, DirPane *dst, CmdArg *ca)
{
	UsrCategory	cat[] = { UIC_USER, UIC_GROUP };
	gchar		*labtext[] = { N_("User"), N_("Group") };
	gint		i, index;
	GtkWidget	*label;
	GList		*list;
	static ChoInfo	cho;

	cho.vbox  = gtk_vbox_new(FALSE, 0);
	cho.label = gtk_label_new("");
	gtk_box_pack_start(GTK_BOX(cho.vbox), cho.label, FALSE, FALSE, 0);
	cho.rowtable = gtk_table_new(2, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(cho.vbox), cho.rowtable, FALSE, FALSE, 5);
	for(i = 0; i < 2; i++)
	{
		label = gtk_label_new(_(labtext[i]));
		gtk_table_attach_defaults(GTK_TABLE(cho.rowtable), label, 0, 1, i, i+1);
		cho.row[i].combo = gtk_combo_new();
		list = usr_string_list_create(cat[i], cat[i] == UIC_USER ? geteuid() : getgid(), &index);
		gtk_combo_set_popdown_strings(GTK_COMBO(cho.row[i].combo), list);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(cho.row[i].combo)->entry), g_list_nth_data(list, index));
		usr_string_list_destroy(list);
		gtk_table_attach_defaults(GTK_TABLE(cho.rowtable), cho.row[i].combo, 1, 2, i, i+1);
	}
	cho.recurse = gtk_check_button_new_with_label(_("Recurse Directories?"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cho.recurse), cho.last_recurse);
	gtk_box_pack_start(GTK_BOX(cho.vbox), cho.recurse, FALSE, FALSE, 0);
	gtk_widget_show_all(cho.vbox);
	return cmd_generic(min, CGF_NODST, cho_body, cho_action, NULL, &cho);
}
