/*
 * File automatically generated by
 * gengen 1.4.1 by Lorenzo Bettini 
 * http://www.gnu.org/software/gengen
 */

#include "c_source.h"

void
c_source_gen_class::generate_c_source(ostream &stream, unsigned int indent)
{
  string indent_str (indent, ' ');
  indent = 0;

  stream << "/*";
  stream << "\n";
  stream << indent_str;
  stream << "  File autogenerated by gengetopt ";
  generate_string (generator_version, stream, indent + indent_str.length ());
  stream << "\n";
  stream << indent_str;
  stream << "  generated with the following command:";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (command_line, stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  The developers of gengetopt consider the fixed text that goes in all";
  stream << "\n";
  stream << indent_str;
  stream << "  gengetopt output files to be in the public domain:";
  stream << "\n";
  stream << indent_str;
  stream << "  we make no copyright claims on it.";
  stream << "\n";
  stream << indent_str;
  stream << "*/";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "/* If we use autoconf.  */";
  stream << "\n";
  stream << indent_str;
  stream << "#ifdef HAVE_CONFIG_H";
  stream << "\n";
  stream << indent_str;
  stream << "#include \"config.h\"";
  stream << "\n";
  stream << indent_str;
  stream << "#endif";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "#include <stdio.h>";
  stream << "\n";
  stream << indent_str;
  stream << "#include <stdlib.h>";
  stream << "\n";
  stream << indent_str;
  stream << "#include <string.h>";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "#ifndef FIX_UNUSED";
  stream << "\n";
  stream << indent_str;
  stream << "#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */";
  stream << "\n";
  stream << indent_str;
  stream << "#endif";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (( ! include_getopt ))
    {
      stream << "#include <getopt.h>";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  stream << "#include \"";
  generate_string (source_name, stream, indent + indent_str.length ());
  stream << ".";
  generate_string (header_file_ext, stream, indent + indent_str.length ());
  stream << "\"";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "const char *";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_purpose = \"";
  generate_string (purpose, stream, indent + indent_str.length ());
  stream << "\";";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "const char *";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_usage = \"Usage: ";
  if (no_package)
    {
      stream << "\" ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << " \"";
    }
  generate_string (usage_string, stream, indent + indent_str.length ());
  stream << "\";";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "const char *";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_description = \"";
  generate_string (description, stream, indent + indent_str.length ());
  stream << "\";";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (( has_hidden || has_details ))
    {
      if (has_details)
        {
          stream << "const char *";
          generate_string (args_info, stream, indent + indent_str.length ());
          stream << "_detailed_help[] = {";
          stream << "\n";
          stream << indent_str;
          indent = 2;
          stream << "  ";
          if (detailed_help_option_print.size () > 0)
            generate_string (detailed_help_option_print, stream, indent + indent_str.length ());
          else
            generate_detailed_help_option_print (stream, indent + indent_str.length ());
          stream << "  0";
          indent = 0;
          stream << "\n";
          stream << indent_str;
          stream << "};";
          stream << "\n";
          stream << indent_str;
          if (has_hidden)
            {
              stream << "static void";
              stream << "\n";
              stream << indent_str;
              stream << "init_full_help_array(void)";
              stream << "\n";
              stream << indent_str;
              stream << "{";
              stream << "\n";
              stream << indent_str;
              indent = 2;
              stream << "  ";
              if (full_help_option_print.size () > 0)
                generate_string (full_help_option_print, stream, indent + indent_str.length ());
              else
                generate_full_help_option_print (stream, indent + indent_str.length ());
              indent = 0;
              stream << "\n";
              stream << indent_str;
              stream << "}";
              stream << "\n";
              stream << indent_str;
              stream << "\n";
              stream << indent_str;
              stream << "const char *";
              generate_string (args_info, stream, indent + indent_str.length ());
              stream << "_full_help[";
              generate_string (help_string_num, stream, indent + indent_str.length ());
              stream << "];";
              stream << "\n";
              stream << indent_str;
            }
        }
      else
        {
          if (has_hidden)
            {
              stream << "const char *";
              generate_string (args_info, stream, indent + indent_str.length ());
              stream << "_full_help[] = {";
              stream << "\n";
              stream << indent_str;
              indent = 2;
              stream << "  ";
              if (full_help_option_print.size () > 0)
                generate_string (full_help_option_print, stream, indent + indent_str.length ());
              else
                generate_full_help_option_print (stream, indent + indent_str.length ());
              stream << "  0";
              indent = 0;
              stream << "\n";
              stream << indent_str;
              stream << "};";
              stream << "\n";
              stream << indent_str;
            }
        }
      stream << "\n";
      stream << indent_str;
      stream << "static void";
      stream << "\n";
      stream << indent_str;
      stream << "init_help_array(void)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      if (help_option_print.size () > 0)
        generate_string (help_option_print, stream, indent + indent_str.length ());
      else
        generate_help_option_print (stream, indent + indent_str.length ());
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "const char *";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << "_help[";
      generate_string (help_string_num, stream, indent + indent_str.length ());
      stream << "];";
      stream << "\n";
      stream << indent_str;
    }
  else
    {
      stream << "const char *";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << "_help[] = {";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      if (help_option_print.size () > 0)
        generate_string (help_option_print, stream, indent + indent_str.length ());
      else
        generate_help_option_print (stream, indent + indent_str.length ());
      stream << "  0";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "};";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  stream << "typedef enum {ARG_NO";
  stream << "\n";
  stream << indent_str;
  if (has_arg_flag)
    {
      stream << "  , ARG_FLAG";
      stream << "\n";
      stream << indent_str;
    }
  if (has_arg_string)
    {
      stream << "  , ARG_STRING";
      stream << "\n";
      stream << indent_str;
    }
  if (has_arg_int)
    {
      stream << "  , ARG_INT";
      stream << "\n";
      stream << indent_str;
    }
  if (has_arg_short)
    {
      stream << "  , ARG_SHORT";
      stream << "\n";
      stream << indent_str;
    }
  if (has_arg_long)
    {
      stream << "  , ARG_LONG";
      stream << "\n";
      stream << indent_str;
    }
  if (has_arg_float)
    {
      stream << "  , ARG_FLOAT";
      stream << "\n";
      stream << indent_str;
    }
  if (has_arg_double)
    {
      stream << "  , ARG_DOUBLE";
      stream << "\n";
      stream << indent_str;
    }
  if (has_arg_longdouble)
    {
      stream << "  , ARG_LONGDOUBLE";
      stream << "\n";
      stream << indent_str;
    }
  if (has_arg_longlong)
    {
      stream << "  , ARG_LONGLONG";
      stream << "\n";
      stream << indent_str;
    }
  if (has_arg_enum)
    {
      stream << "  , ARG_ENUM";
      stream << "\n";
      stream << indent_str;
    }
  stream << "} ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_arg_type;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static";
  stream << "\n";
  stream << indent_str;
  stream << "void clear_given (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info);";
  stream << "\n";
  stream << indent_str;
  stream << "static";
  stream << "\n";
  stream << indent_str;
  stream << "void clear_args (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_internal (int argc, char **argv, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info,";
  stream << "\n";
  stream << indent_str;
  stream << "                        struct ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params *params, const char *additional_error);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (check_required_options)
    {
      stream << "static int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_required2 (struct ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << " *args_info, const char *prog_name, const char *additional_error);";
      stream << "\n";
      stream << indent_str;
    }
  if (cmd_list)
    {
      stream << "struct line_list";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  char * string_arg;";
      stream << "\n";
      stream << indent_str;
      stream << "  struct line_list * next;";
      stream << "\n";
      stream << indent_str;
      stream << "};";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "static struct line_list *cmd_line_list = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "static struct line_list *cmd_line_list_tmp = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "static void";
      stream << "\n";
      stream << indent_str;
      stream << "free_cmd_list(void)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  /* free the list of a previous call */";
      stream << "\n";
      stream << indent_str;
      stream << "  if (cmd_line_list)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      while (cmd_line_list) {";
      stream << "\n";
      stream << indent_str;
      stream << "        cmd_line_list_tmp = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "        cmd_line_list = cmd_line_list->next;";
      stream << "\n";
      stream << indent_str;
      stream << "        free (cmd_line_list_tmp->string_arg);";
      stream << "\n";
      stream << indent_str;
      stream << "        free (cmd_line_list_tmp);";
      stream << "\n";
      stream << indent_str;
      stream << "      }";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  if (option_values.size () > 0)
    generate_string (option_values, stream, indent + indent_str.length ());
  else
    generate_option_values (stream, indent + indent_str.length ());
  stream << indent_str;
  if (do_generate_strdup)
    {
      stream << "static char *";
      stream << "\n";
      stream << indent_str;
      stream << "gengetopt_strdup (const char *s);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "static";
  stream << "\n";
  stream << indent_str;
  stream << "void clear_given (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  if (given_init.size () > 0)
    generate_string (given_init, stream, indent + indent_str.length ());
  else
    generate_given_init (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static";
  stream << "\n";
  stream << indent_str;
  stream << "void clear_args (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  FIX_UNUSED (args_info);";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  if (clear_arg.size () > 0)
    generate_string (clear_arg, stream, indent + indent_str.length ());
  else
    generate_clear_arg (stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static";
  stream << "\n";
  stream << indent_str;
  stream << "void init_args_info(struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  if (( has_hidden && has_details ))
    {
      stream << "  init_full_help_array(); ";
    }
  stream << "\n";
  stream << indent_str;
  if (( has_hidden || has_details ))
    {
      stream << "  init_help_array(); ";
    }
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  if (init_args_info.size () > 0)
    generate_string (init_args_info, stream, indent + indent_str.length ());
  else
    generate_init_args_info (stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_print_version (void)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  printf (\"%s %s\\n\",";
  stream << "\n";
  stream << indent_str;
  stream << "     (strlen(";
  generate_string (package_var_name, stream, indent + indent_str.length ());
  stream << "_NAME) ? ";
  generate_string (package_var_name, stream, indent + indent_str.length ());
  stream << "_NAME : ";
  generate_string (package_var_name, stream, indent + indent_str.length ());
  stream << "),";
  stream << "\n";
  stream << indent_str;
  indent = 5;
  stream << "     ";
  generate_string (version_var_name, stream, indent + indent_str.length ());
  stream << ");";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "static void print_help_common(void) {";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_print_version ();";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  if (strlen(";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_purpose) > 0)";
  stream << "\n";
  stream << indent_str;
  stream << "    printf(\"\\n%s\\n\", ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_purpose);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  if (strlen(";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_usage) > 0)";
  stream << "\n";
  stream << indent_str;
  stream << "    printf(\"\\n%s\\n\", ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_usage);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  printf(\"\\n\");";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  if (strlen(";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_description) > 0)";
  stream << "\n";
  stream << indent_str;
  stream << "    printf(\"%s\\n\\n\", ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_description);";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_print_help (void)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  int i = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "  print_help_common();";
  stream << "\n";
  stream << indent_str;
  stream << "  while (";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_help[i])";
  stream << "\n";
  stream << indent_str;
  stream << "    printf(\"%s\\n\", ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << "_help[i++]);";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (has_hidden)
    {
      stream << "void";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_print_full_help (void)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int i = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  print_help_common();";
      stream << "\n";
      stream << indent_str;
      stream << "  while (";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << "_full_help[i])";
      stream << "\n";
      stream << indent_str;
      stream << "    printf(\"%s\\n\", ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << "_full_help[i++]);";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  if (has_details)
    {
      stream << "void";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_print_detailed_help (void)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int i = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  print_help_common();";
      stream << "\n";
      stream << indent_str;
      stream << "  while (";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << "_detailed_help[i])";
      stream << "\n";
      stream << indent_str;
      stream << "    printf(\"%s\\n\", ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << "_detailed_help[i++]);";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_init (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  clear_given (args_info);";
  stream << "\n";
  stream << indent_str;
  stream << "  clear_args (args_info);";
  stream << "\n";
  stream << indent_str;
  stream << "  init_args_info (args_info);";
  stream << "\n";
  stream << indent_str;
  if (handle_unamed)
    {
      stream << "\n";
      stream << indent_str;
      stream << "  args_info->inputs = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  args_info->inputs_num = 0;";
      stream << "\n";
      stream << indent_str;
    }
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params_init(struct ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params *params)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  if (params)";
  stream << "\n";
  stream << indent_str;
  stream << "    { ";
  stream << "\n";
  stream << indent_str;
  stream << "      params->override = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "      params->initialize = 1;";
  stream << "\n";
  stream << indent_str;
  stream << "      params->check_required = 1;";
  stream << "\n";
  stream << indent_str;
  stream << "      params->check_ambiguity = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "      params->print_errors = 1;";
  stream << "\n";
  stream << indent_str;
  stream << "    }";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "struct ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params *";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params_create(void)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  struct ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params *params = ";
  stream << "\n";
  stream << indent_str;
  stream << "    (struct ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params *)malloc(sizeof(struct ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params));";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params_init(params);  ";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "  return params;";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (has_typed_options)
    {
      stream << "static void";
      stream << "\n";
      stream << indent_str;
      stream << "free_string_field (char **s)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  if (*s)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      free (*s);";
      stream << "\n";
      stream << indent_str;
      stream << "      *s = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  if (multiple_token_functions)
    {
      stream << "/** ";
      stream << "@";
      stream << "brief generic value variable */";
      stream << "\n";
      stream << indent_str;
      stream << "union generic_value {";
      stream << "\n";
      stream << indent_str;
      if (( has_arg_int || has_arg_enum ))
        {
          stream << "    int int_arg;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_short)
        {
          stream << "    short short_arg;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_long)
        {
          stream << "    long long_arg;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_float)
        {
          stream << "    float float_arg;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_double)
        {
          stream << "    double double_arg;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_longdouble)
        {
          stream << "    long double longdouble_arg;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_longlong)
        {
          stream << "#ifdef HAVE_LONG_LONG";
          stream << "\n";
          stream << indent_str;
          stream << "    long long int longlong_arg;";
          stream << "\n";
          stream << indent_str;
          stream << "#else";
          stream << "\n";
          stream << indent_str;
          stream << "    long longlong_arg;";
          stream << "\n";
          stream << indent_str;
          stream << "#endif";
          stream << "\n";
          stream << indent_str;
        }
      stream << "    char *string_arg;";
      stream << "\n";
      stream << indent_str;
      stream << "    const char *default_string_arg;";
      stream << "\n";
      stream << indent_str;
      stream << "};";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "/** ";
      stream << "@";
      stream << "brief holds temporary values for multiple options */";
      stream << "\n";
      stream << indent_str;
      stream << "struct generic_list";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  union generic_value arg;";
      stream << "\n";
      stream << indent_str;
      stream << "  char *orig;";
      stream << "\n";
      stream << indent_str;
      stream << "  struct generic_list *next;";
      stream << "\n";
      stream << indent_str;
      stream << "};";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "/**";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "brief add a node at the head of the list ";
      stream << "\n";
      stream << indent_str;
      stream << " */";
      stream << "\n";
      stream << indent_str;
      stream << "static void add_node(struct generic_list **list) {";
      stream << "\n";
      stream << indent_str;
      stream << "  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));";
      stream << "\n";
      stream << indent_str;
      stream << "  new_node->next = *list;";
      stream << "\n";
      stream << indent_str;
      stream << "  *list = new_node;";
      stream << "\n";
      stream << indent_str;
      stream << "  new_node->arg.string_arg = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  new_node->orig = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      if (( ( ! multiple_options_all_string ) && multiple_token_functions ))
        {
          stream << "/**";
          stream << "\n";
          stream << indent_str;
          stream << " * The passed arg parameter is NOT set to 0 from this function";
          stream << "\n";
          stream << indent_str;
          stream << " */";
          stream << "\n";
          stream << indent_str;
          stream << "static void";
          stream << "\n";
          stream << indent_str;
          stream << "free_multiple_field(unsigned int len, void *arg, char ***orig)";
          stream << "\n";
          stream << indent_str;
          stream << "{";
          stream << "\n";
          stream << indent_str;
          stream << "  unsigned int i;";
          stream << "\n";
          stream << indent_str;
          stream << "  if (arg) {";
          stream << "\n";
          stream << indent_str;
          stream << "    for (i = 0; i < len; ++i)";
          stream << "\n";
          stream << indent_str;
          stream << "      {";
          stream << "\n";
          stream << indent_str;
          stream << "        free_string_field(&((*orig)[i]));";
          stream << "\n";
          stream << indent_str;
          stream << "      }";
          stream << "\n";
          stream << indent_str;
          stream << "\n";
          stream << indent_str;
          stream << "    free (arg);";
          stream << "\n";
          stream << indent_str;
          stream << "    free (*orig);";
          stream << "\n";
          stream << indent_str;
          stream << "    *orig = 0;";
          stream << "\n";
          stream << indent_str;
          stream << "  }";
          stream << "\n";
          stream << indent_str;
          stream << "}";
          stream << "\n";
          stream << indent_str;
        }
      stream << "\n";
      stream << indent_str;
      if (multiple_options_string)
        {
          stream << "static void";
          stream << "\n";
          stream << indent_str;
          stream << "free_multiple_string_field(unsigned int len, char ***arg, char ***orig)";
          stream << "\n";
          stream << indent_str;
          stream << "{";
          stream << "\n";
          stream << indent_str;
          stream << "  unsigned int i;";
          stream << "\n";
          stream << indent_str;
          stream << "  if (*arg) {";
          stream << "\n";
          stream << indent_str;
          stream << "    for (i = 0; i < len; ++i)";
          stream << "\n";
          stream << indent_str;
          stream << "      {";
          stream << "\n";
          stream << indent_str;
          stream << "        free_string_field(&((*arg)[i]));";
          stream << "\n";
          stream << indent_str;
          stream << "        free_string_field(&((*orig)[i]));";
          stream << "\n";
          stream << indent_str;
          stream << "      }";
          stream << "\n";
          stream << indent_str;
          stream << "    free_string_field(&((*arg)[0])); /* free default string */";
          stream << "\n";
          stream << indent_str;
          stream << "\n";
          stream << indent_str;
          stream << "    free (*arg);";
          stream << "\n";
          stream << indent_str;
          stream << "    *arg = 0;";
          stream << "\n";
          stream << indent_str;
          stream << "    free (*orig);";
          stream << "\n";
          stream << indent_str;
          stream << "    *orig = 0;";
          stream << "\n";
          stream << indent_str;
          stream << "  }";
          stream << "\n";
          stream << indent_str;
          stream << "}";
          stream << "\n";
          stream << indent_str;
        }
    }
  stream << "\n";
  stream << indent_str;
  stream << "static void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_release (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  if (handle_unamed)
    {
      stream << "  unsigned int i;";
    }
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  if (free.size () > 0)
    generate_string (free, stream, indent + indent_str.length ());
  else
    generate_free (stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  if (handle_unamed)
    {
      stream << "  for (i = 0; i < args_info->inputs_num; ++i)";
      stream << "\n";
      stream << indent_str;
      stream << "    free (args_info->inputs [i]);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (args_info->inputs_num)";
      stream << "\n";
      stream << indent_str;
      stream << "    free (args_info->inputs);";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  stream << "  clear_given (args_info);";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (check_possible_values)
    {
      stream << "/**";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param val the value to check";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param values the possible values";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "return the index of the matched value:";
      stream << "\n";
      stream << indent_str;
      stream << " * -1 if no value matched,";
      stream << "\n";
      stream << indent_str;
      stream << " * -2 if more than one value has matched";
      stream << "\n";
      stream << indent_str;
      stream << " */";
      stream << "\n";
      stream << indent_str;
      stream << "static int";
      stream << "\n";
      stream << indent_str;
      stream << "check_possible_values(const char *val, const char *values[])";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int i, found, last;";
      stream << "\n";
      stream << indent_str;
      stream << "  size_t len;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (!val)   /* otherwise strlen() crashes below */";
      stream << "\n";
      stream << indent_str;
      stream << "    return -1; /* -1 means no argument for the option */";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  found = last = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  for (i = 0, len = strlen(val); values[i]; ++i)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      if (strncmp(val, values[i], len) == 0)";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          ++found;";
      stream << "\n";
      stream << indent_str;
      stream << "          last = i;";
      stream << "\n";
      stream << indent_str;
      stream << "          if (strlen(values[i]) == len)";
      stream << "\n";
      stream << indent_str;
      stream << "            return i; /* exact macth no need to check more */";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (found == 1) /* one match: OK */";
      stream << "\n";
      stream << indent_str;
      stream << "    return last;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return (found ? -2 : -1); /* return many values or none matched */";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  stream << "static void";
  stream << "\n";
  stream << indent_str;
  stream << "write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  if (check_possible_values)
    {
      stream << "  int found = -1;";
      stream << "\n";
      stream << indent_str;
    }
  else
    {
      stream << "  FIX_UNUSED (values);";
      stream << "\n";
      stream << indent_str;
    }
  stream << "  if (arg) {";
  stream << "\n";
  stream << indent_str;
  if (check_possible_values)
    {
      stream << "    if (values) {";
      stream << "\n";
      stream << indent_str;
      stream << "      found = check_possible_values(arg, values);      ";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "    if (found >= 0)";
      stream << "\n";
      stream << indent_str;
      stream << "      fprintf(outfile, \"%s=\\\"%s\\\" # %s\\n\", opt, arg, values[found]);";
      stream << "\n";
      stream << indent_str;
      stream << "    else";
      stream << "\n";
      stream << indent_str;
      stream << "      fprintf(outfile, \"%s=\\\"%s\\\"\\n\", opt, arg);";
      stream << "\n";
      stream << indent_str;
    }
  else
    {
      stream << "    fprintf(outfile, \"%s=\\\"%s\\\"\\n\", opt, arg);";
      stream << "\n";
      stream << indent_str;
    }
  stream << "  } else {";
  stream << "\n";
  stream << indent_str;
  stream << "    fprintf(outfile, \"%s\\n\", opt);";
  stream << "\n";
  stream << indent_str;
  stream << "  }";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (multiple_options)
    {
      stream << "static void";
      stream << "\n";
      stream << indent_str;
      stream << "write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int i;";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "  for (i = 0; i < len; ++i)";
      stream << "\n";
      stream << indent_str;
      stream << "    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_dump(FILE *outfile, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  int i = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  if (!outfile)";
  stream << "\n";
  stream << indent_str;
  stream << "    {";
  stream << "\n";
  stream << indent_str;
  stream << "      fprintf (stderr, \"%s: cannot dump options to stream\\n\", ";
  generate_string (package_var_name, stream, indent + indent_str.length ());
  stream << ");";
  stream << "\n";
  stream << indent_str;
  stream << "      return EXIT_FAILURE;";
  stream << "\n";
  stream << indent_str;
  stream << "    }";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  if (file_save_loop.size () > 0)
    generate_string (file_save_loop, stream, indent + indent_str.length ());
  else
    generate_file_save_loop (stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  i = EXIT_SUCCESS;";
  stream << "\n";
  stream << indent_str;
  stream << "  return i;";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_file_save(const char *filename, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  FILE *outfile;";
  stream << "\n";
  stream << indent_str;
  stream << "  int i = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  outfile = fopen(filename, \"w\");";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  if (!outfile)";
  stream << "\n";
  stream << indent_str;
  stream << "    {";
  stream << "\n";
  stream << indent_str;
  stream << "      fprintf (stderr, \"%s: cannot open file for writing: %s\\n\", ";
  generate_string (package_var_name, stream, indent + indent_str.length ());
  stream << ", filename);";
  stream << "\n";
  stream << indent_str;
  stream << "      return EXIT_FAILURE;";
  stream << "\n";
  stream << indent_str;
  stream << "    }";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  i = ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_dump(outfile, args_info);";
  stream << "\n";
  stream << indent_str;
  stream << "  fclose (outfile);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  return i;";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "void";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_free (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_release (args_info);";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (do_generate_strdup)
    {
      stream << "/** ";
      stream << "@";
      stream << "brief replacement of strdup, which is not standard */";
      stream << "\n";
      stream << indent_str;
      stream << "char *";
      stream << "\n";
      stream << indent_str;
      stream << "gengetopt_strdup (const char *s)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  char *result = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  if (!s)";
      stream << "\n";
      stream << indent_str;
      stream << "    return result;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  result = (char*)malloc(strlen(s) + 1);";
      stream << "\n";
      stream << indent_str;
      stream << "  if (result == (char*)0)";
      stream << "\n";
      stream << indent_str;
      stream << "    return (char*)0;";
      stream << "\n";
      stream << indent_str;
      stream << "  strcpy(result, s);";
      stream << "\n";
      stream << indent_str;
      stream << "  return result;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  if (multiple_token_functions)
    {
      stream << "static char *";
      stream << "\n";
      stream << indent_str;
      stream << "get_multiple_arg_token(const char *arg)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  const char *tok;";
      stream << "\n";
      stream << indent_str;
      stream << "  char *ret;";
      stream << "\n";
      stream << indent_str;
      stream << "  size_t len, num_of_escape, i, j;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (!arg)";
      stream << "\n";
      stream << indent_str;
      stream << "    return 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  tok = strchr (arg, ',');";
      stream << "\n";
      stream << indent_str;
      stream << "  num_of_escape = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  /* make sure it is not escaped */";
      stream << "\n";
      stream << indent_str;
      stream << "  while (tok)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      if (*(tok-1) == '\\\\')";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          /* find the next one */";
      stream << "\n";
      stream << indent_str;
      stream << "          tok = strchr (tok+1, ',');";
      stream << "\n";
      stream << indent_str;
      stream << "          ++num_of_escape;";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "      else";
      stream << "\n";
      stream << indent_str;
      stream << "        break;";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (tok)";
      stream << "\n";
      stream << indent_str;
      stream << "    len = (size_t)(tok - arg + 1);";
      stream << "\n";
      stream << indent_str;
      stream << "  else";
      stream << "\n";
      stream << indent_str;
      stream << "    len = strlen (arg) + 1;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  len -= num_of_escape;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  ret = (char *) malloc (len);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  i = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  j = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  while (arg[i] && (j < len-1))";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      if (arg[i] == '\\\\' && ";
      stream << "\n";
      stream << indent_str;
      stream << "	  arg[ i + 1 ] && ";
      stream << "\n";
      stream << indent_str;
      stream << "	  arg[ i + 1 ] == ',')";
      stream << "\n";
      stream << indent_str;
      stream << "        ++i;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      ret[j++] = arg[i++];";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  ret[len-1] = '\\0';";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return ret;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "static const char *";
      stream << "\n";
      stream << indent_str;
      stream << "get_multiple_arg_token_next(const char *arg)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  const char *tok;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (!arg)";
      stream << "\n";
      stream << indent_str;
      stream << "    return 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  tok = strchr (arg, ',');";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  /* make sure it is not escaped */";
      stream << "\n";
      stream << indent_str;
      stream << "  while (tok)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      if (*(tok-1) == '\\\\')";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          /* find the next one */";
      stream << "\n";
      stream << indent_str;
      stream << "          tok = strchr (tok+1, ',');";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "      else";
      stream << "\n";
      stream << indent_str;
      stream << "        break;";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (! tok || strlen(tok) == 1)";
      stream << "\n";
      stream << indent_str;
      stream << "    return 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return tok+1;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  if (multiple_options)
    {
      stream << "static int";
      stream << "\n";
      stream << indent_str;
      stream << "check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "int";
      stream << "\n";
      stream << indent_str;
      stream << "check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int error = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (option_given && (min > 0 || max > 0))";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      if (min > 0 && max > 0)";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          if (min == max)";
      stream << "\n";
      stream << indent_str;
      stream << "            {";
      stream << "\n";
      stream << indent_str;
      stream << "              /* specific occurrences */";
      stream << "\n";
      stream << indent_str;
      stream << "              if (option_given != (unsigned int) min)";
      stream << "\n";
      stream << indent_str;
      stream << "                {";
      stream << "\n";
      stream << indent_str;
      stream << "                  fprintf (stderr, \"%s: %s option occurrences must be %d\\n\",";
      stream << "\n";
      stream << indent_str;
      stream << "                    prog_name, option_desc, min);";
      stream << "\n";
      stream << indent_str;
      stream << "                  error = 1;";
      stream << "\n";
      stream << indent_str;
      stream << "                }";
      stream << "\n";
      stream << indent_str;
      stream << "            }";
      stream << "\n";
      stream << indent_str;
      stream << "          else if (option_given < (unsigned int) min";
      stream << "\n";
      stream << indent_str;
      stream << "                || option_given > (unsigned int) max)";
      stream << "\n";
      stream << indent_str;
      stream << "            {";
      stream << "\n";
      stream << indent_str;
      stream << "              /* range occurrences */";
      stream << "\n";
      stream << indent_str;
      stream << "              fprintf (stderr, \"%s: %s option occurrences must be between %d and %d\\n\",";
      stream << "\n";
      stream << indent_str;
      stream << "                prog_name, option_desc, min, max);";
      stream << "\n";
      stream << indent_str;
      stream << "              error = 1;";
      stream << "\n";
      stream << indent_str;
      stream << "            }";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "      else if (min > 0)";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          /* at least check */";
      stream << "\n";
      stream << indent_str;
      stream << "          if (option_given < min)";
      stream << "\n";
      stream << indent_str;
      stream << "            {";
      stream << "\n";
      stream << indent_str;
      stream << "              fprintf (stderr, \"%s: %s option occurrences must be at least %d\\n\",";
      stream << "\n";
      stream << indent_str;
      stream << "                prog_name, option_desc, min);";
      stream << "\n";
      stream << indent_str;
      stream << "              error = 1;";
      stream << "\n";
      stream << indent_str;
      stream << "            }";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "      else if (max > 0)";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          /* at most check */";
      stream << "\n";
      stream << indent_str;
      stream << "          if (option_given > max)";
      stream << "\n";
      stream << indent_str;
      stream << "            {";
      stream << "\n";
      stream << indent_str;
      stream << "              fprintf (stderr, \"%s: %s option occurrences must be at most %d\\n\",";
      stream << "\n";
      stream << indent_str;
      stream << "                prog_name, option_desc, max);";
      stream << "\n";
      stream << indent_str;
      stream << "              error = 1;";
      stream << "\n";
      stream << indent_str;
      stream << "            }";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      indent = 4;
      stream << "    ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "  return error;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
    }
  if (reset_groups.size () > 0)
    generate_string (reset_groups, stream, indent + indent_str.length ());
  else
    generate_reset_groups (stream, indent + indent_str.length ());
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << " (int argc, char **argv, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  return ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "2 (argc, argv, args_info, 0, 1, 1);";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_ext (int argc, char **argv, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info,";
  stream << "\n";
  stream << indent_str;
  stream << "                   struct ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params *params)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  int result;";
  stream << "\n";
  stream << indent_str;
  stream << "  result = ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_internal (argc, argv, args_info, params, 0);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (final_exit, stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "2 (int argc, char **argv, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info, int override, int initialize, int check_required)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  int result;";
  stream << "\n";
  stream << indent_str;
  stream << "  struct ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params params;";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "  params.override = override;";
  stream << "\n";
  stream << indent_str;
  stream << "  params.initialize = initialize;";
  stream << "\n";
  stream << indent_str;
  stream << "  params.check_required = check_required;";
  stream << "\n";
  stream << indent_str;
  stream << "  params.check_ambiguity = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "  params.print_errors = 1;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  result = ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_internal (argc, argv, args_info, &params, 0);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (final_exit, stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_required (struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info, const char *prog_name)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  if (check_required_options)
    {
      stream << "  int result = EXIT_SUCCESS;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_required2(args_info, prog_name, 0) > 0)";
      stream << "\n";
      stream << indent_str;
      stream << "    result = EXIT_FAILURE;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      generate_string (final_exit, stream, indent + indent_str.length ());
      indent = 0;
      stream << "\n";
      stream << indent_str;
    }
  else
    {
      stream << "  FIX_UNUSED (args_info);";
      stream << "\n";
      stream << indent_str;
      stream << "  FIX_UNUSED (prog_name);";
      stream << "\n";
      stream << indent_str;
      stream << "  return EXIT_SUCCESS;";
      stream << "\n";
      stream << indent_str;
    }
  stream << "}";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (check_required_options)
    {
      stream << "int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_required2 (struct ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << " *args_info, const char *prog_name, const char *additional_error)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int error = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  FIX_UNUSED (additional_error);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  /* checks for required options */";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      if (handle_required.size () > 0)
        generate_string (handle_required, stream, indent + indent_str.length ());
      else
        generate_handle_required (stream, indent + indent_str.length ());
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "  /* checks for dependences among options */";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      if (handle_dependencies.size () > 0)
        generate_string (handle_dependencies, stream, indent + indent_str.length ());
      else
        generate_handle_dependencies (stream, indent + indent_str.length ());
      indent = 0;
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return error;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  if (include_getopt)
    {
      if (custom_getopt.size () > 0)
        generate_string (custom_getopt, stream, indent + indent_str.length ());
      else
        generate_custom_getopt (stream, indent + indent_str.length ());
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  stream << "static char *package_name = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (( ! no_options ))
    {
      stream << "/**";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "brief updates an option";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param field the generic pointer to the field to update";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param orig_field the pointer to the orig field";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param field_given the pointer to the number of occurrence of this option";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param prev_given the pointer to the number of occurrence already seen";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param value the argument for this option (if null no arg was specified)";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param possible_values the possible values for this option (if specified)";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param default_value the default value (in case the option only accepts fixed values)";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param arg_type the type of this option";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param check_ambiguity ";
      stream << "@";
      stream << "see ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_params.check_ambiguity";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param override ";
      stream << "@";
      stream << "see ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_params.override";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param no_free whether to free a possible previous value";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param multiple_option whether this is a multiple option";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param long_opt the corresponding long option";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param short_opt the corresponding short option (or '-' if none)";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param additional_error possible further error specification";
      stream << "\n";
      stream << indent_str;
      stream << " */";
      stream << "\n";
      stream << indent_str;
      stream << "static";
      stream << "\n";
      stream << indent_str;
      stream << "int update_arg(void *field, char **orig_field,";
      stream << "\n";
      stream << indent_str;
      stream << "               unsigned int *field_given, unsigned int *prev_given, ";
      stream << "\n";
      stream << indent_str;
      stream << "               char *value, const char *possible_values[],";
      stream << "\n";
      stream << indent_str;
      stream << "               const char *default_value,";
      stream << "\n";
      stream << indent_str;
      indent = 15;
      stream << "               ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_arg_type arg_type,";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "               int check_ambiguity, int override,";
      stream << "\n";
      stream << indent_str;
      stream << "               int no_free, int multiple_option,";
      stream << "\n";
      stream << indent_str;
      stream << "               const char *long_opt, char short_opt,";
      stream << "\n";
      stream << indent_str;
      stream << "               const char *additional_error)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  char *stop_char = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  const char *val = value;";
      stream << "\n";
      stream << indent_str;
      stream << "  int found;";
      stream << "\n";
      stream << indent_str;
      if (has_arg_string)
        {
          stream << "  char **string_field;";
          stream << "\n";
          stream << indent_str;
        }
      stream << "  FIX_UNUSED (field);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  stop_char = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  found = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      if (short_opt != '-')";
      stream << "\n";
      stream << indent_str;
      stream << "        fprintf (stderr, \"%s: `--%s' (`-%c') option given more than once%s\\n\", ";
      stream << "\n";
      stream << indent_str;
      stream << "               package_name, long_opt, short_opt,";
      stream << "\n";
      stream << indent_str;
      stream << "               (additional_error ? additional_error : \"\"));";
      stream << "\n";
      stream << indent_str;
      stream << "      else";
      stream << "\n";
      stream << indent_str;
      stream << "        fprintf (stderr, \"%s: `--%s' option given more than once%s\\n\", ";
      stream << "\n";
      stream << indent_str;
      stream << "               package_name, long_opt,";
      stream << "\n";
      stream << indent_str;
      stream << "               (additional_error ? additional_error : \"\"));";
      stream << "\n";
      stream << indent_str;
      stream << "      return 1; /* failure */";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      if (check_possible_values)
        {
          stream << "  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)";
          stream << "\n";
          stream << indent_str;
          stream << "    {";
          stream << "\n";
          stream << indent_str;
          stream << "      if (short_opt != '-')";
          stream << "\n";
          stream << indent_str;
          stream << "        fprintf (stderr, \"%s: %s argument, \\\"%s\\\", for option `--%s' (`-%c')%s\\n\", ";
          stream << "\n";
          stream << indent_str;
          stream << "          package_name, (found == -2) ? \"ambiguous\" : \"invalid\", value, long_opt, short_opt,";
          stream << "\n";
          stream << indent_str;
          stream << "          (additional_error ? additional_error : \"\"));";
          stream << "\n";
          stream << indent_str;
          stream << "      else";
          stream << "\n";
          stream << indent_str;
          stream << "        fprintf (stderr, \"%s: %s argument, \\\"%s\\\", for option `--%s'%s\\n\", ";
          stream << "\n";
          stream << indent_str;
          stream << "          package_name, (found == -2) ? \"ambiguous\" : \"invalid\", value, long_opt,";
          stream << "\n";
          stream << indent_str;
          stream << "          (additional_error ? additional_error : \"\"));";
          stream << "\n";
          stream << indent_str;
          stream << "      return 1; /* failure */";
          stream << "\n";
          stream << indent_str;
          stream << "    }";
          stream << "\n";
          stream << indent_str;
        }
      else
        {
          stream << "  FIX_UNUSED (default_value);";
          stream << "\n";
          stream << indent_str;
        }
      stream << "    ";
      stream << "\n";
      stream << indent_str;
      stream << "  if (field_given && *field_given && ! override)";
      stream << "\n";
      stream << indent_str;
      stream << "    return 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  if (prev_given)";
      stream << "\n";
      stream << indent_str;
      stream << "    (*prev_given)++;";
      stream << "\n";
      stream << indent_str;
      stream << "  if (field_given)";
      stream << "\n";
      stream << indent_str;
      stream << "    (*field_given)++;";
      stream << "\n";
      stream << indent_str;
      stream << "  if (possible_values)";
      stream << "\n";
      stream << indent_str;
      stream << "    val = possible_values[found];";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  switch(arg_type) {";
      stream << "\n";
      stream << indent_str;
      if (has_arg_flag)
        {
          stream << "  case ARG_FLAG:";
          stream << "\n";
          stream << indent_str;
          stream << "    *((int *)field) = !*((int *)field);";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_int)
        {
          stream << "  case ARG_INT:";
          stream << "\n";
          stream << indent_str;
          stream << "    if (val) *((int *)field) = strtol (val, &stop_char, 0);";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_short)
        {
          stream << "  case ARG_SHORT:";
          stream << "\n";
          stream << indent_str;
          stream << "    if (val) *((short *)field) = (short)strtol (val, &stop_char, 0);";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_long)
        {
          stream << "  case ARG_LONG:";
          stream << "\n";
          stream << indent_str;
          stream << "    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_float)
        {
          stream << "  case ARG_FLOAT:";
          stream << "\n";
          stream << indent_str;
          stream << "    if (val) *((float *)field) = (float)strtod (val, &stop_char);";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_double)
        {
          stream << "  case ARG_DOUBLE:";
          stream << "\n";
          stream << indent_str;
          stream << "    if (val) *((double *)field) = strtod (val, &stop_char);";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_longdouble)
        {
          stream << "  case ARG_LONGDOUBLE:";
          stream << "\n";
          stream << indent_str;
          stream << "    if (val) *((long double *)field) = (long double)strtod (val, &stop_char);";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_longlong)
        {
          stream << "  case ARG_LONGLONG:";
          stream << "\n";
          stream << indent_str;
          stream << "#ifdef HAVE_LONG_LONG";
          stream << "\n";
          stream << indent_str;
          stream << "    if (val) *((long long int*)field) = (long long int) strtol (val, &stop_char, 0);";
          stream << "\n";
          stream << indent_str;
          stream << "#else";
          stream << "\n";
          stream << indent_str;
          stream << "    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);";
          stream << "\n";
          stream << indent_str;
          stream << "#endif";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_enum)
        {
          stream << "  case ARG_ENUM:";
          stream << "\n";
          stream << indent_str;
          stream << "    if (val) *((int *)field) = found;";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_string)
        {
          stream << "  case ARG_STRING:";
          stream << "\n";
          stream << indent_str;
          stream << "    if (val) {";
          stream << "\n";
          stream << indent_str;
          stream << "      string_field = (char **)field;";
          stream << "\n";
          stream << indent_str;
          stream << "      if (!no_free && *string_field)";
          stream << "\n";
          stream << indent_str;
          stream << "        free (*string_field); /* free previous string */";
          stream << "\n";
          stream << indent_str;
          stream << "      *string_field = gengetopt_strdup (val);";
          stream << "\n";
          stream << indent_str;
          stream << "    }";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
        }
      stream << "  default:";
      stream << "\n";
      stream << indent_str;
      stream << "    break;";
      stream << "\n";
      stream << indent_str;
      stream << "  };";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      if (( ( ( ( ( ( has_arg_int || has_arg_short ) || has_arg_long ) || has_arg_float ) || has_arg_double ) || has_arg_longdouble ) || has_arg_longlong ))
        {
          stream << "  /* check numeric conversion */";
          stream << "\n";
          stream << indent_str;
          stream << "  switch(arg_type) {";
          stream << "\n";
          stream << indent_str;
          if (has_arg_int)
            {
              stream << "  case ARG_INT:";
              stream << "\n";
              stream << indent_str;
            }
          if (has_arg_short)
            {
              stream << "  case ARG_SHORT:";
              stream << "\n";
              stream << indent_str;
            }
          if (has_arg_long)
            {
              stream << "  case ARG_LONG:";
              stream << "\n";
              stream << indent_str;
            }
          if (has_arg_float)
            {
              stream << "  case ARG_FLOAT:";
              stream << "\n";
              stream << indent_str;
            }
          if (has_arg_double)
            {
              stream << "  case ARG_DOUBLE:";
              stream << "\n";
              stream << indent_str;
            }
          if (has_arg_longdouble)
            {
              stream << "  case ARG_LONGDOUBLE:";
              stream << "\n";
              stream << indent_str;
            }
          if (has_arg_longlong)
            {
              stream << "  case ARG_LONGLONG:";
              stream << "\n";
              stream << indent_str;
            }
          stream << "    if (val && !(stop_char && *stop_char == '\\0')) {";
          stream << "\n";
          stream << indent_str;
          stream << "      fprintf(stderr, \"%s: invalid numeric value: %s\\n\", package_name, val);";
          stream << "\n";
          stream << indent_str;
          stream << "      return 1; /* failure */";
          stream << "\n";
          stream << indent_str;
          stream << "    }";
          stream << "\n";
          stream << indent_str;
          stream << "    break;";
          stream << "\n";
          stream << indent_str;
          stream << "  default:";
          stream << "\n";
          stream << indent_str;
          stream << "    ;";
          stream << "\n";
          stream << indent_str;
          stream << "  };";
          stream << "\n";
          stream << indent_str;
        }
      stream << "\n";
      stream << indent_str;
      stream << "  /* store the original value */";
      stream << "\n";
      stream << indent_str;
      stream << "  switch(arg_type) {";
      stream << "\n";
      stream << indent_str;
      stream << "  case ARG_NO:";
      stream << "\n";
      stream << indent_str;
      if (has_arg_flag)
        {
          stream << "  case ARG_FLAG:";
          stream << "\n";
          stream << indent_str;
        }
      stream << "    break;";
      stream << "\n";
      stream << indent_str;
      stream << "  default:";
      stream << "\n";
      stream << indent_str;
      stream << "    if (value && orig_field) {";
      stream << "\n";
      stream << indent_str;
      stream << "      if (no_free) {";
      stream << "\n";
      stream << indent_str;
      stream << "        *orig_field = value;";
      stream << "\n";
      stream << indent_str;
      stream << "      } else {";
      stream << "\n";
      stream << indent_str;
      stream << "        if (*orig_field)";
      stream << "\n";
      stream << indent_str;
      stream << "          free (*orig_field); /* free previous string */";
      stream << "\n";
      stream << indent_str;
      stream << "        *orig_field = gengetopt_strdup (value);";
      stream << "\n";
      stream << indent_str;
      stream << "      }";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "  };";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return 0; /* OK */";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  if (multiple_token_functions)
    {
      stream << "/**";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "brief store information about a multiple option in a temporary list";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "param list where to (temporarily) store multiple options";
      stream << "\n";
      stream << indent_str;
      stream << " */";
      stream << "\n";
      stream << indent_str;
      stream << "static";
      stream << "\n";
      stream << indent_str;
      stream << "int update_multiple_arg_temp(struct generic_list **list,";
      stream << "\n";
      stream << indent_str;
      stream << "               unsigned int *prev_given, const char *val,";
      stream << "\n";
      stream << indent_str;
      stream << "               const char *possible_values[], const char *default_value,";
      stream << "\n";
      stream << indent_str;
      indent = 15;
      stream << "               ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_arg_type arg_type,";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "               const char *long_opt, char short_opt,";
      stream << "\n";
      stream << indent_str;
      stream << "               const char *additional_error)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  /* store single arguments */";
      stream << "\n";
      stream << indent_str;
      stream << "  char *multi_token;";
      stream << "\n";
      stream << indent_str;
      stream << "  const char *multi_next;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (arg_type == ARG_NO) {";
      stream << "\n";
      stream << indent_str;
      stream << "    (*prev_given)++;";
      stream << "\n";
      stream << indent_str;
      stream << "    return 0; /* OK */";
      stream << "\n";
      stream << indent_str;
      stream << "  }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  multi_token = get_multiple_arg_token(val);";
      stream << "\n";
      stream << indent_str;
      stream << "  multi_next = get_multiple_arg_token_next (val);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  while (1)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      add_node (list);";
      stream << "\n";
      stream << indent_str;
      stream << "      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,";
      stream << "\n";
      stream << indent_str;
      stream << "          prev_given, multi_token, possible_values, default_value, ";
      stream << "\n";
      stream << indent_str;
      stream << "          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {";
      stream << "\n";
      stream << indent_str;
      stream << "        if (multi_token) free(multi_token);";
      stream << "\n";
      stream << indent_str;
      stream << "        return 1; /* failure */";
      stream << "\n";
      stream << indent_str;
      stream << "      }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      if (multi_next)";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          multi_token = get_multiple_arg_token(multi_next);";
      stream << "\n";
      stream << indent_str;
      stream << "          multi_next = get_multiple_arg_token_next (multi_next);";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "      else";
      stream << "\n";
      stream << indent_str;
      stream << "        break;";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return 0; /* OK */";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "/**";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "brief free the passed list (including possible string argument)";
      stream << "\n";
      stream << indent_str;
      stream << " */";
      stream << "\n";
      stream << indent_str;
      stream << "static";
      stream << "\n";
      stream << indent_str;
      stream << "void free_list(struct generic_list *list, short string_arg)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  if (list) {";
      stream << "\n";
      stream << indent_str;
      stream << "    struct generic_list *tmp;";
      stream << "\n";
      stream << indent_str;
      stream << "    while (list)";
      stream << "\n";
      stream << indent_str;
      stream << "      {";
      stream << "\n";
      stream << indent_str;
      stream << "        tmp = list;";
      stream << "\n";
      stream << indent_str;
      stream << "        if (string_arg && list->arg.string_arg)";
      stream << "\n";
      stream << indent_str;
      stream << "          free (list->arg.string_arg);";
      stream << "\n";
      stream << indent_str;
      stream << "        if (list->orig)";
      stream << "\n";
      stream << indent_str;
      stream << "          free (list->orig);";
      stream << "\n";
      stream << indent_str;
      stream << "        list = list->next;";
      stream << "\n";
      stream << indent_str;
      stream << "        free (tmp);";
      stream << "\n";
      stream << indent_str;
      stream << "      }";
      stream << "\n";
      stream << indent_str;
      stream << "  }";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "/**";
      stream << "\n";
      stream << indent_str;
      stream << " * ";
      stream << "@";
      stream << "brief updates a multiple option starting from the passed list";
      stream << "\n";
      stream << indent_str;
      stream << " */";
      stream << "\n";
      stream << indent_str;
      stream << "static";
      stream << "\n";
      stream << indent_str;
      stream << "void update_multiple_arg(void *field, char ***orig_field,";
      stream << "\n";
      stream << indent_str;
      stream << "               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,";
      stream << "\n";
      stream << indent_str;
      indent = 15;
      stream << "               ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_arg_type arg_type,";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "               struct generic_list *list)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int i;";
      stream << "\n";
      stream << indent_str;
      stream << "  struct generic_list *tmp;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (prev_given && list) {";
      stream << "\n";
      stream << indent_str;
      stream << "    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "    switch(arg_type) {";
      stream << "\n";
      stream << indent_str;
      if (( has_arg_int || has_arg_enum ))
        {
          if (has_arg_int)
            {
              stream << "    case ARG_INT:";
              stream << "\n";
              stream << indent_str;
            }
          if (has_arg_enum)
            {
              stream << "    case ARG_ENUM:";
              stream << "\n";
              stream << indent_str;
            }
          stream << "      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_short)
        {
          stream << "    case ARG_SHORT:";
          stream << "\n";
          stream << indent_str;
          stream << "      *((short **)field) = (short *)realloc (*((short **)field), (field_given + prev_given) * sizeof (short)); break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_long)
        {
          stream << "    case ARG_LONG:";
          stream << "\n";
          stream << indent_str;
          stream << "      *((long **)field) = (long *)realloc (*((long **)field), (field_given + prev_given) * sizeof (long)); break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_float)
        {
          stream << "    case ARG_FLOAT:";
          stream << "\n";
          stream << indent_str;
          stream << "      *((float **)field) = (float *)realloc (*((float **)field), (field_given + prev_given) * sizeof (float)); break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_double)
        {
          stream << "    case ARG_DOUBLE:";
          stream << "\n";
          stream << indent_str;
          stream << "      *((double **)field) = (double *)realloc (*((double **)field), (field_given + prev_given) * sizeof (double)); break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_longdouble)
        {
          stream << "    case ARG_LONGDOUBLE:";
          stream << "\n";
          stream << indent_str;
          stream << "      *((long double **)field) = (long double *)realloc (*((long double **)field), (field_given + prev_given) * sizeof (long double)); break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_longlong)
        {
          stream << "    case ARG_LONGLONG:";
          stream << "\n";
          stream << indent_str;
          stream << "#ifdef HAVE_LONG_LONG";
          stream << "\n";
          stream << indent_str;
          stream << "      *((long long int **)field) = (long long int *)realloc (*((long long int **)field), (field_given + prev_given) * sizeof (long long int)); break;";
          stream << "\n";
          stream << indent_str;
          stream << "#else";
          stream << "\n";
          stream << indent_str;
          stream << "      *((long **)field) = (long *)realloc (*((long **)field), (field_given + prev_given) * sizeof (long)); break;";
          stream << "\n";
          stream << indent_str;
          stream << "#endif";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_string)
        {
          stream << "    case ARG_STRING:";
          stream << "\n";
          stream << indent_str;
          stream << "      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;";
          stream << "\n";
          stream << indent_str;
        }
      stream << "    default:";
      stream << "\n";
      stream << indent_str;
      stream << "      break;";
      stream << "\n";
      stream << indent_str;
      stream << "    };";
      stream << "\n";
      stream << indent_str;
      indent = 4;
      stream << "    ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "    for (i = (prev_given - 1); i >= 0; --i)";
      stream << "\n";
      stream << indent_str;
      stream << "      {";
      stream << "\n";
      stream << indent_str;
      stream << "        tmp = list;";
      stream << "\n";
      stream << indent_str;
      indent = 8;
      stream << "        ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "        switch(arg_type) {";
      stream << "\n";
      stream << indent_str;
      if (has_arg_int)
        {
          stream << "        case ARG_INT:";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_short)
        {
          stream << "        case ARG_SHORT:";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((short **)field))[i + field_given] = tmp->arg.short_arg; break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_long)
        {
          stream << "        case ARG_LONG:";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((long **)field))[i + field_given] = tmp->arg.long_arg; break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_float)
        {
          stream << "        case ARG_FLOAT:";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((float **)field))[i + field_given] = tmp->arg.float_arg; break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_double)
        {
          stream << "        case ARG_DOUBLE:";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((double **)field))[i + field_given] = tmp->arg.double_arg; break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_longdouble)
        {
          stream << "        case ARG_LONGDOUBLE:";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((long double **)field))[i + field_given] = tmp->arg.longdouble_arg; break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_longlong)
        {
          stream << "        case ARG_LONGLONG:";
          stream << "\n";
          stream << indent_str;
          stream << "#ifdef HAVE_LONG_LONG";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((long long int **)field))[i + field_given] = tmp->arg.longlong_arg; break;";
          stream << "\n";
          stream << indent_str;
          stream << "#else";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((long **)field))[i + field_given] = tmp->arg.longlong_arg; break;";
          stream << "\n";
          stream << indent_str;
          stream << "#endif";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_enum)
        {
          stream << "        case ARG_ENUM:";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_string)
        {
          stream << "        case ARG_STRING:";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;";
          stream << "\n";
          stream << indent_str;
        }
      stream << "        default:";
      stream << "\n";
      stream << indent_str;
      stream << "          break;";
      stream << "\n";
      stream << indent_str;
      stream << "        }        ";
      stream << "\n";
      stream << indent_str;
      stream << "        (*orig_field) [i + field_given] = list->orig;";
      stream << "\n";
      stream << indent_str;
      stream << "        list = list->next;";
      stream << "\n";
      stream << indent_str;
      stream << "        free (tmp);";
      stream << "\n";
      stream << indent_str;
      stream << "      }";
      stream << "\n";
      stream << indent_str;
      stream << "  } else { /* set the default value */";
      stream << "\n";
      stream << indent_str;
      stream << "    if (default_value && ! field_given) {";
      stream << "\n";
      stream << indent_str;
      stream << "      switch(arg_type) {";
      stream << "\n";
      stream << indent_str;
      if (( has_arg_int || has_arg_enum ))
        {
          if (has_arg_int)
            {
              stream << "      case ARG_INT:";
              stream << "\n";
              stream << indent_str;
            }
          if (has_arg_enum)
            {
              stream << "      case ARG_ENUM:";
              stream << "\n";
              stream << indent_str;
            }
          stream << "        if (! *((int **)field)) {";
          stream << "\n";
          stream << indent_str;
          stream << "          *((int **)field) = (int *)malloc (sizeof (int));";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((int **)field))[0] = default_value->int_arg; ";
          stream << "\n";
          stream << indent_str;
          stream << "        }";
          stream << "\n";
          stream << indent_str;
          stream << "        break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_short)
        {
          stream << "      case ARG_SHORT:";
          stream << "\n";
          stream << indent_str;
          stream << "        if (! *((short **)field)) {";
          stream << "\n";
          stream << indent_str;
          stream << "          *((short **)field) = (short *)malloc (sizeof (short));";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((short **)field))[0] = default_value->short_arg;";
          stream << "\n";
          stream << indent_str;
          stream << "        }";
          stream << "\n";
          stream << indent_str;
          stream << "        break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_long)
        {
          stream << "      case ARG_LONG:";
          stream << "\n";
          stream << indent_str;
          stream << "        if (! *((long **)field)) {";
          stream << "\n";
          stream << indent_str;
          stream << "          *((long **)field) = (long *)malloc (sizeof (long));";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((long **)field))[0] = default_value->long_arg;";
          stream << "\n";
          stream << indent_str;
          stream << "        }";
          stream << "\n";
          stream << indent_str;
          stream << "        break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_float)
        {
          stream << "      case ARG_FLOAT:";
          stream << "\n";
          stream << indent_str;
          stream << "        if (! *((float **)field)) {";
          stream << "\n";
          stream << indent_str;
          stream << "          *((float **)field) = (float *)malloc (sizeof (float));";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((float **)field))[0] = default_value->float_arg;";
          stream << "\n";
          stream << indent_str;
          stream << "        }";
          stream << "\n";
          stream << indent_str;
          stream << "        break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_double)
        {
          stream << "      case ARG_DOUBLE:";
          stream << "\n";
          stream << indent_str;
          stream << "        if (! *((double **)field)) {";
          stream << "\n";
          stream << indent_str;
          stream << "          *((double **)field) = (double *)malloc (sizeof (double));";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((double **)field))[0] = default_value->double_arg;";
          stream << "\n";
          stream << indent_str;
          stream << "        }";
          stream << "\n";
          stream << indent_str;
          stream << "        break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_longdouble)
        {
          stream << "      case ARG_LONGDOUBLE:";
          stream << "\n";
          stream << indent_str;
          stream << "        if (! *((long double **)field)) {";
          stream << "\n";
          stream << indent_str;
          stream << "          *((long double **)field) = (long double *)malloc (sizeof (long double));";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((long double **)field))[0] = default_value->longdouble_arg;";
          stream << "\n";
          stream << indent_str;
          stream << "        }";
          stream << "\n";
          stream << indent_str;
          stream << "        break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_longlong)
        {
          stream << "      case ARG_LONGLONG:";
          stream << "\n";
          stream << indent_str;
          stream << "#ifdef HAVE_LONG_LONG";
          stream << "\n";
          stream << indent_str;
          stream << "        if (! *((long long int **)field)) {";
          stream << "\n";
          stream << indent_str;
          stream << "          *((long long int **)field) = (long long int *)malloc (sizeof (long long int));";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((long long int **)field))[0] = default_value->longlong_arg;";
          stream << "\n";
          stream << indent_str;
          stream << "        }";
          stream << "\n";
          stream << indent_str;
          stream << "#else";
          stream << "\n";
          stream << indent_str;
          stream << "        if (! *((long **)field)) {";
          stream << "\n";
          stream << indent_str;
          stream << "          *((long **)field) = (long *)malloc (sizeof (long));";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((long **)field))[0] = default_value->longlong_arg;";
          stream << "\n";
          stream << indent_str;
          stream << "        }";
          stream << "\n";
          stream << indent_str;
          stream << "#endif";
          stream << "\n";
          stream << indent_str;
          stream << "        break;";
          stream << "\n";
          stream << indent_str;
        }
      if (has_arg_string)
        {
          stream << "      case ARG_STRING:";
          stream << "\n";
          stream << indent_str;
          stream << "        if (! *((char ***)field)) {";
          stream << "\n";
          stream << indent_str;
          stream << "          *((char ***)field) = (char **)malloc (sizeof (char *));";
          stream << "\n";
          stream << indent_str;
          stream << "          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);";
          stream << "\n";
          stream << indent_str;
          stream << "        }";
          stream << "\n";
          stream << indent_str;
          stream << "        break;";
          stream << "\n";
          stream << indent_str;
        }
      stream << "      default: break;";
      stream << "\n";
      stream << indent_str;
      stream << "      }";
      stream << "\n";
      stream << indent_str;
      stream << "      if (!(*orig_field)) {";
      stream << "\n";
      stream << indent_str;
      stream << "        *orig_field = (char **) malloc (sizeof (char *));";
      stream << "\n";
      stream << indent_str;
      stream << "        (*orig_field)[0] = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "      }";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "  }";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
    }
  if (has_modes)
    {
      stream << "\n";
      stream << indent_str;
      stream << "static int check_modes(";
      stream << "\n";
      stream << indent_str;
      stream << "  int given1[], const char *options1[],";
      stream << "\n";
      stream << indent_str;
      stream << "                       int given2[], const char *options2[])";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int i = 0, j = 0, errors = 0;";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "  while (given1[i] >= 0) {";
      stream << "\n";
      stream << indent_str;
      stream << "    if (given1[i]) {";
      stream << "\n";
      stream << indent_str;
      stream << "      while (given2[j] >= 0) {";
      stream << "\n";
      stream << indent_str;
      stream << "        if (given2[j]) {";
      stream << "\n";
      stream << indent_str;
      stream << "          ++errors;";
      stream << "\n";
      stream << indent_str;
      stream << "          fprintf(stderr, \"%s: option %s conflicts with option %s\\n\",";
      stream << "\n";
      stream << indent_str;
      stream << "                  package_name, options1[i], options2[j]);";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "        ++j;";
      stream << "\n";
      stream << indent_str;
      stream << "      }";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "    ++i;";
      stream << "\n";
      stream << indent_str;
      stream << "  }";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "  return errors;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  stream << "int";
  stream << "\n";
  stream << indent_str;
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_internal (";
  stream << "\n";
  stream << indent_str;
  stream << "  int argc, char **argv, struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " *args_info,";
  stream << "\n";
  stream << indent_str;
  stream << "                        struct ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_params *params, const char *additional_error)";
  stream << "\n";
  stream << indent_str;
  stream << "{";
  stream << "\n";
  stream << indent_str;
  stream << "  int c;	/* Character of the parsed option.  */";
  stream << "\n";
  stream << indent_str;
  if (multiple_options_with_default)
    {
      stream << "  union generic_value multiple_default_value;";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  indent = 2;
  if (list_def.size () > 0)
    generate_string (list_def, stream, indent + indent_str.length ());
  else
    generate_list_def (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "  int error = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "  struct ";
  generate_string (args_info, stream, indent + indent_str.length ());
  stream << " local_args_info;";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "  int override;";
  stream << "\n";
  stream << indent_str;
  stream << "  int initialize;";
  stream << "\n";
  stream << indent_str;
  stream << "  int check_required;";
  stream << "\n";
  stream << indent_str;
  stream << "  int check_ambiguity;";
  stream << "\n";
  stream << indent_str;
  if (include_getopt)
    {
      stream << "\n";
      stream << indent_str;
      stream << "  char *optarg;";
      stream << "\n";
      stream << indent_str;
      stream << "  int optind;";
      stream << "\n";
      stream << indent_str;
      stream << "  int opterr;";
      stream << "\n";
      stream << indent_str;
      stream << "  int optopt;";
      stream << "\n";
      stream << indent_str;
    }
  stream << "  ";
  stream << "\n";
  stream << indent_str;
  stream << "  package_name = argv[0];";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "  override = params->override;";
  stream << "\n";
  stream << indent_str;
  stream << "  initialize = params->initialize;";
  stream << "\n";
  stream << indent_str;
  stream << "  check_required = params->check_required;";
  stream << "\n";
  stream << indent_str;
  stream << "  check_ambiguity = params->check_ambiguity;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  if (initialize)";
  stream << "\n";
  stream << indent_str;
  indent = 4;
  stream << "    ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_init (args_info);";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_init (&local_args_info);";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  optarg = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "  optind = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "  opterr = params->print_errors;";
  stream << "\n";
  stream << indent_str;
  stream << "  optopt = '?';";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  while (1)";
  stream << "\n";
  stream << indent_str;
  stream << "    {";
  stream << "\n";
  stream << indent_str;
  stream << "      int option_index = 0;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "      static struct option long_options[] = {";
  stream << "\n";
  stream << indent_str;
  indent = 8;
  if (long_option_struct.size () > 0)
    generate_string (long_option_struct, stream, indent + indent_str.length ());
  else
    generate_long_option_struct (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "        { 0,  0, 0, 0 }";
  stream << "\n";
  stream << indent_str;
  stream << "      };";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (include_getopt)
    {
      stream << "      custom_optarg = optarg;";
      stream << "\n";
      stream << indent_str;
      stream << "      custom_optind = optind;";
      stream << "\n";
      stream << indent_str;
      stream << "      custom_opterr = opterr;";
      stream << "\n";
      stream << indent_str;
      stream << "      custom_optopt = optopt;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      c = custom_getopt_long (argc, argv, \"";
      generate_string (getopt_string, stream, indent + indent_str.length ());
      stream << "\", long_options, &option_index);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      optarg = custom_optarg;";
      stream << "\n";
      stream << indent_str;
      stream << "      optind = custom_optind;";
      stream << "\n";
      stream << indent_str;
      stream << "      opterr = custom_opterr;";
      stream << "\n";
      stream << indent_str;
      stream << "      optopt = custom_optopt;";
      stream << "\n";
      stream << indent_str;
    }
  else
    {
      stream << "      c = getopt_long (argc, argv, \"";
      generate_string (getopt_string, stream, indent + indent_str.length ());
      stream << "\", long_options, &option_index);";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  stream << "      if (c == -1) break;	/* Exit from `while (1)' loop.  */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "      switch (c)";
  stream << "\n";
  stream << indent_str;
  stream << "        {";
  stream << "\n";
  stream << indent_str;
  indent = 8;
  if (handle_option.size () > 0)
    generate_string (handle_option, stream, indent + indent_str.length ());
  else
    generate_handle_option (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "        case 0:	/* Long option with no short option */";
  stream << "\n";
  stream << indent_str;
  indent = 10;
  if (handle_no_short_option.size () > 0)
    generate_string (handle_no_short_option, stream, indent + indent_str.length ());
  else
    generate_handle_no_short_option (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  if (handle_question_mark)
    {
      stream << "        case '?':	/* Invalid option.  */";
      stream << "\n";
      stream << indent_str;
      stream << "          /* `getopt_long' already printed an error message.  */";
      stream << "\n";
      stream << indent_str;
      stream << "          goto failure;";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  stream << "        default:	/* bug: option not considered.  */";
  stream << "\n";
  stream << indent_str;
  stream << "          fprintf (stderr, \"%s: option unknown: %c%s\\n\", ";
  generate_string (package_var_name, stream, indent + indent_str.length ());
  stream << ", c, (additional_error ? additional_error : \"\"));";
  stream << "\n";
  stream << indent_str;
  stream << "          abort ();";
  stream << "\n";
  stream << indent_str;
  stream << "        } /* switch */";
  stream << "\n";
  stream << indent_str;
  stream << "    } /* while */";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  if (handle_group.size () > 0)
    generate_string (handle_group, stream, indent + indent_str.length ());
  else
    generate_handle_group (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  if (multiple_fill_array.size () > 0)
    generate_string (multiple_fill_array, stream, indent + indent_str.length ());
  else
    generate_multiple_fill_array (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  indent = 2;
  if (update_multiple_given.size () > 0)
    generate_string (update_multiple_given, stream, indent + indent_str.length ());
  else
    generate_update_multiple_given (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  indent = 2;
  if (check_modes.size () > 0)
    generate_string (check_modes, stream, indent + indent_str.length ());
  else
    generate_check_modes (stream, indent + indent_str.length ());
  indent = 0;
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (check_required_options)
    {
      stream << "  if (check_required)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      error += ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_required2 (args_info, argv[0], additional_error);";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
    }
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_release (&local_args_info);";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "  if ( error )";
  stream << "\n";
  stream << indent_str;
  stream << "    return (EXIT_FAILURE);";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  if (handle_unamed)
    {
      stream << "  if (optind < argc)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      int i = 0 ;";
      stream << "\n";
      stream << indent_str;
      stream << "      int found_prog_name = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "      /* whether program name, i.e., argv[0], is in the remaining args";
      stream << "\n";
      stream << indent_str;
      stream << "         (this may happen with some implementations of getopt,";
      stream << "\n";
      stream << indent_str;
      stream << "          but surely not with the one included by gengetopt) */";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      if (include_getopt)
        {
          
      
        }
      else
        {
          stream << "      i = optind;";
          stream << "\n";
          stream << indent_str;
          stream << "      while (i < argc)";
          stream << "\n";
          stream << indent_str;
          stream << "        if (argv[i++] == argv[0]) {";
          stream << "\n";
          stream << indent_str;
          stream << "          found_prog_name = 1;";
          stream << "\n";
          stream << indent_str;
          stream << "          break;";
          stream << "\n";
          stream << indent_str;
          stream << "        }";
          stream << "\n";
          stream << indent_str;
          stream << "      i = 0;";
          stream << "\n";
          stream << indent_str;
        }
      stream << "\n";
      stream << indent_str;
      stream << "      args_info->inputs_num = argc - optind - found_prog_name;";
      stream << "\n";
      stream << indent_str;
      stream << "      args_info->inputs =";
      stream << "\n";
      stream << indent_str;
      stream << "        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;";
      stream << "\n";
      stream << indent_str;
      stream << "      while (optind < argc)";
      stream << "\n";
      stream << indent_str;
      if (include_getopt)
        {
          stream << "        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;";
          stream << "\n";
          stream << indent_str;
        }
      else
        {
          stream << "        if (argv[optind++] != argv[0])";
          stream << "\n";
          stream << indent_str;
          stream << "          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;";
          stream << "\n";
          stream << indent_str;
        }
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
  stream << "  return 0;";
  stream << "\n";
  stream << indent_str;
  stream << "\n";
  stream << indent_str;
  stream << "failure:";
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  if (list_free.size () > 0)
    generate_string (list_free, stream, indent + indent_str.length ());
  else
    generate_list_free (stream, indent + indent_str.length ());
  indent = 0;
  stream << "\n";
  stream << indent_str;
  indent = 2;
  stream << "  ";
  generate_string (parser_name, stream, indent + indent_str.length ());
  stream << "_release (&local_args_info);";
  indent = 0;
  stream << "\n";
  stream << indent_str;
  stream << "  return (EXIT_FAILURE);";
  stream << "\n";
  stream << indent_str;
  stream << "}";
  stream << "\n";
  stream << indent_str;
  if (conf_parser)
    {
      stream << "\n";
      stream << indent_str;
      stream << "#ifndef CONFIG_FILE_LINE_SIZE";
      stream << "\n";
      stream << indent_str;
      stream << "#define CONFIG_FILE_LINE_SIZE 2048";
      stream << "\n";
      stream << indent_str;
      stream << "#endif";
      stream << "\n";
      stream << indent_str;
      stream << "#define ADDITIONAL_ERROR \" in configuration file \"";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)";
      stream << "\n";
      stream << indent_str;
      stream << "/* 3 is for \"--\" and \"=\" */";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "static int";
      stream << "\n";
      stream << indent_str;
      stream << "_";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_configfile (const char *filename, int *my_argc)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  FILE* file;";
      stream << "\n";
      stream << indent_str;
      stream << "  char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];";
      stream << "\n";
      stream << indent_str;
      stream << "  char linebuf[CONFIG_FILE_LINE_SIZE];";
      stream << "\n";
      stream << indent_str;
      stream << "  int line_num = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  int result = 0, equal;";
      stream << "\n";
      stream << indent_str;
      stream << "  char *fopt, *farg;";
      stream << "\n";
      stream << indent_str;
      stream << "  char *str_index;";
      stream << "\n";
      stream << indent_str;
      stream << "  size_t len, next_token;";
      stream << "\n";
      stream << indent_str;
      stream << "  char delimiter;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if ((file = fopen(filename, \"r\")) == 0)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      fprintf (stderr, \"%s: Error opening configuration file '%s'\\n\",";
      stream << "\n";
      stream << indent_str;
      indent = 15;
      stream << "               ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ", filename);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "      return EXIT_FAILURE;";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != 0)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      ++line_num;";
      stream << "\n";
      stream << indent_str;
      stream << "      my_argv[0] = '\\0';";
      stream << "\n";
      stream << indent_str;
      stream << "      len = strlen(linebuf);";
      stream << "\n";
      stream << indent_str;
      stream << "      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          fprintf (stderr, \"%s:%s:%d: Line too long in configuration file\\n\",";
      stream << "\n";
      stream << indent_str;
      indent = 19;
      stream << "                   ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ", filename, line_num);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "          result = EXIT_FAILURE;";
      stream << "\n";
      stream << indent_str;
      stream << "          break;";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* find first non-whitespace character in the line */";
      stream << "\n";
      stream << indent_str;
      stream << "      next_token = strspn (linebuf, \" \\t\\r\\n\");";
      stream << "\n";
      stream << indent_str;
      stream << "      str_index  = linebuf + next_token;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      if ( str_index[0] == '\\0' || str_index[0] == '#')";
      stream << "\n";
      stream << indent_str;
      stream << "        continue; /* empty line or comment line is skipped */";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      fopt = str_index;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* truncate fopt at the end of the first non-valid character */";
      stream << "\n";
      stream << indent_str;
      stream << "      next_token = strcspn (fopt, \" \\t\\r\\n=\");";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      if (fopt[next_token] == '\\0') /* the line is over */";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          farg  = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "          equal = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "          goto noarg;";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* remember if equal sign is present */";
      stream << "\n";
      stream << indent_str;
      stream << "      equal = (fopt[next_token] == '=');";
      stream << "\n";
      stream << indent_str;
      stream << "      fopt[next_token++] = '\\0';";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* advance pointers to the next token after the end of fopt */";
      stream << "\n";
      stream << indent_str;
      stream << "      next_token += strspn (fopt + next_token, \" \\t\\r\\n\");";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* check for the presence of equal sign, and if so, skip it */";
      stream << "\n";
      stream << indent_str;
      stream << "      if ( !equal )";
      stream << "\n";
      stream << indent_str;
      stream << "        if ((equal = (fopt[next_token] == '=')))";
      stream << "\n";
      stream << indent_str;
      stream << "          {";
      stream << "\n";
      stream << indent_str;
      stream << "            next_token++;";
      stream << "\n";
      stream << indent_str;
      stream << "            next_token += strspn (fopt + next_token, \" \\t\\r\\n\");";
      stream << "\n";
      stream << indent_str;
      stream << "          }";
      stream << "\n";
      stream << indent_str;
      stream << "      str_index  += next_token;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* find argument */";
      stream << "\n";
      stream << indent_str;
      stream << "      farg = str_index;";
      stream << "\n";
      stream << indent_str;
      stream << "      if ( farg[0] == '\\\"' || farg[0] == '\\'' )";
      stream << "\n";
      stream << indent_str;
      stream << "        { /* quoted argument */";
      stream << "\n";
      stream << indent_str;
      stream << "          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */";
      stream << "\n";
      stream << indent_str;
      stream << "          if (! str_index)";
      stream << "\n";
      stream << indent_str;
      stream << "            {";
      stream << "\n";
      stream << indent_str;
      stream << "              fprintf";
      stream << "\n";
      stream << indent_str;
      stream << "                (stderr,";
      stream << "\n";
      stream << indent_str;
      stream << "                 \"%s:%s:%d: unterminated string in configuration file\\n\",";
      stream << "\n";
      stream << indent_str;
      indent = 17;
      stream << "                 ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ", filename, line_num);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "              result = EXIT_FAILURE;";
      stream << "\n";
      stream << indent_str;
      stream << "              break;";
      stream << "\n";
      stream << indent_str;
      stream << "            }";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "      else";
      stream << "\n";
      stream << indent_str;
      stream << "        { /* read up the remaining part up to a delimiter */";
      stream << "\n";
      stream << indent_str;
      stream << "          next_token = strcspn (farg, \" \\t\\r\\n#\\'\\\"\");";
      stream << "\n";
      stream << indent_str;
      stream << "          str_index += next_token;";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* truncate farg at the delimiter and store it for further check */";
      stream << "\n";
      stream << indent_str;
      stream << "      delimiter = *str_index, *str_index++ = '\\0';";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      /* everything but comment is illegal at the end of line */";
      stream << "\n";
      stream << indent_str;
      stream << "      if (delimiter != '\\0' && delimiter != '#')";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          str_index += strspn(str_index, \" \\t\\r\\n\");";
      stream << "\n";
      stream << indent_str;
      stream << "          if (*str_index != '\\0' && *str_index != '#')";
      stream << "\n";
      stream << indent_str;
      stream << "            {";
      stream << "\n";
      stream << indent_str;
      stream << "              fprintf";
      stream << "\n";
      stream << indent_str;
      stream << "                (stderr,";
      stream << "\n";
      stream << indent_str;
      stream << "                 \"%s:%s:%d: malformed string in configuration file\\n\",";
      stream << "\n";
      stream << indent_str;
      indent = 17;
      stream << "                 ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ", filename, line_num);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "              result = EXIT_FAILURE;";
      stream << "\n";
      stream << indent_str;
      stream << "              break;";
      stream << "\n";
      stream << indent_str;
      stream << "            }";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "    noarg:";
      stream << "\n";
      stream << indent_str;
      stream << "      if (!strcmp(fopt,\"include\")) {";
      stream << "\n";
      stream << indent_str;
      stream << "        if (farg && *farg) {";
      stream << "\n";
      stream << indent_str;
      stream << "          result = _";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_configfile(farg, my_argc);";
      stream << "\n";
      stream << indent_str;
      stream << "        } else {";
      stream << "\n";
      stream << indent_str;
      stream << "          fprintf(stderr, \"%s:%s:%d: include requires a filename argument.\\n\",";
      stream << "\n";
      stream << indent_str;
      indent = 18;
      stream << "                  ";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ", filename, line_num);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "        continue;";
      stream << "\n";
      stream << indent_str;
      stream << "      }";
      stream << "\n";
      stream << indent_str;
      stream << "      len = strlen(fopt);";
      stream << "\n";
      stream << indent_str;
      stream << "      strcat (my_argv, len > 1 ? \"--\" : \"-\");";
      stream << "\n";
      stream << indent_str;
      stream << "      strcat (my_argv, fopt);";
      stream << "\n";
      stream << indent_str;
      stream << "      if (len > 1 && ((farg && *farg) || equal))";
      stream << "\n";
      stream << indent_str;
      stream << "        strcat (my_argv, \"=\");";
      stream << "\n";
      stream << indent_str;
      stream << "      if (farg && *farg)";
      stream << "\n";
      stream << indent_str;
      stream << "        strcat (my_argv, farg);";
      stream << "\n";
      stream << indent_str;
      stream << "      ++(*my_argc);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));";
      stream << "\n";
      stream << indent_str;
      stream << "      cmd_line_list_tmp->next = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "      cmd_line_list = cmd_line_list_tmp;";
      stream << "\n";
      stream << indent_str;
      stream << "      cmd_line_list->string_arg = gengetopt_strdup(my_argv);";
      stream << "\n";
      stream << indent_str;
      stream << "    } /* while */";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (file)";
      stream << "\n";
      stream << indent_str;
      stream << "    fclose(file);";
      stream << "\n";
      stream << indent_str;
      stream << "  return result;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_configfile (";
      stream << "\n";
      stream << indent_str;
      stream << "  const char *filename,";
      stream << "\n";
      stream << indent_str;
      stream << "                           struct ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << " *args_info,";
      stream << "\n";
      stream << indent_str;
      stream << "                           int override, int initialize, int check_required)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  struct ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_params params;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  params.override = override;";
      stream << "\n";
      stream << indent_str;
      stream << "  params.initialize = initialize;";
      stream << "\n";
      stream << indent_str;
      stream << "  params.check_required = check_required;";
      stream << "\n";
      stream << indent_str;
      stream << "  params.check_ambiguity = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  params.print_errors = 1;";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "  return ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_config_file (filename, args_info, &params);";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_config_file (const char *filename,";
      stream << "\n";
      stream << indent_str;
      stream << "                           struct ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << " *args_info,";
      stream << "\n";
      stream << indent_str;
      stream << "                           struct ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_params *params)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  int i, result;";
      stream << "\n";
      stream << indent_str;
      stream << "  int my_argc = 1;";
      stream << "\n";
      stream << indent_str;
      stream << "  char **my_argv_arg;";
      stream << "\n";
      stream << indent_str;
      stream << "  char *additional_error;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  /* store the program name */";
      stream << "\n";
      stream << indent_str;
      stream << "  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));";
      stream << "\n";
      stream << indent_str;
      stream << "  cmd_line_list_tmp->next = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "  cmd_line_list = cmd_line_list_tmp;";
      stream << "\n";
      stream << indent_str;
      stream << "  cmd_line_list->string_arg = gengetopt_strdup (";
      generate_string (package_var_name, stream, indent + indent_str.length ());
      stream << ");";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  result = _";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_configfile(filename, &my_argc);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (result != EXIT_FAILURE) {";
      stream << "\n";
      stream << indent_str;
      stream << "    my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));";
      stream << "\n";
      stream << indent_str;
      stream << "    cmd_line_list_tmp = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "    for (i = my_argc - 1; i >= 0; --i) {";
      stream << "\n";
      stream << indent_str;
      stream << "      my_argv_arg[i] = cmd_line_list_tmp->string_arg;";
      stream << "\n";
      stream << indent_str;
      stream << "      cmd_line_list_tmp = cmd_line_list_tmp->next;";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "    my_argv_arg[my_argc] = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "    additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);";
      stream << "\n";
      stream << indent_str;
      stream << "    strcpy (additional_error, ADDITIONAL_ERROR);";
      stream << "\n";
      stream << indent_str;
      stream << "    strcat (additional_error, filename);";
      stream << "\n";
      stream << indent_str;
      stream << "    result =";
      stream << "\n";
      stream << indent_str;
      indent = 6;
      stream << "      ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_internal (my_argc, my_argv_arg, args_info,";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "                              params,";
      stream << "\n";
      stream << indent_str;
      stream << "                              additional_error);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "    free (additional_error);";
      stream << "\n";
      stream << indent_str;
      stream << "    free (my_argv_arg);";
      stream << "\n";
      stream << indent_str;
      stream << "  }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  free_cmd_list();";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      generate_string (final_exit, stream, indent + indent_str.length ());
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
    }
  if (generate_string_parser)
    {
      stream << "\n";
      stream << indent_str;
      stream << "static unsigned int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_create_argv(const char *cmdline_, char ***argv_ptr, const char *prog_name)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  char *cmdline, *p;";
      stream << "\n";
      stream << indent_str;
      stream << "  size_t n = 0, j;";
      stream << "\n";
      stream << indent_str;
      stream << "  int i;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  if (prog_name) {";
      stream << "\n";
      stream << indent_str;
      stream << "    cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));";
      stream << "\n";
      stream << indent_str;
      stream << "    cmd_line_list_tmp->next = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "    cmd_line_list = cmd_line_list_tmp;";
      stream << "\n";
      stream << indent_str;
      stream << "    cmd_line_list->string_arg = gengetopt_strdup (prog_name);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "    ++n;";
      stream << "\n";
      stream << indent_str;
      stream << "  }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  cmdline = gengetopt_strdup(cmdline_);";
      stream << "\n";
      stream << indent_str;
      stream << "  p = cmdline;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  while (p && strlen(p))";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      j = strcspn(p, \" \\t\");";
      stream << "\n";
      stream << indent_str;
      stream << "      ++n;";
      stream << "\n";
      stream << indent_str;
      stream << "      if (j && j < strlen(p))";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          p[j] = '\\0';";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "          cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));";
      stream << "\n";
      stream << indent_str;
      stream << "          cmd_line_list_tmp->next = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "          cmd_line_list = cmd_line_list_tmp;";
      stream << "\n";
      stream << indent_str;
      stream << "          cmd_line_list->string_arg = gengetopt_strdup (p);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "          p += (j+1);";
      stream << "\n";
      stream << indent_str;
      stream << "          p += strspn(p, \" \\t\");";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "      else";
      stream << "\n";
      stream << indent_str;
      stream << "        {";
      stream << "\n";
      stream << indent_str;
      stream << "          cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));";
      stream << "\n";
      stream << indent_str;
      stream << "          cmd_line_list_tmp->next = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "          cmd_line_list = cmd_line_list_tmp;";
      stream << "\n";
      stream << indent_str;
      stream << "          cmd_line_list->string_arg = gengetopt_strdup (p);";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "          break;";
      stream << "\n";
      stream << indent_str;
      stream << "        }";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  *argv_ptr = (char **) malloc((n + 1) * sizeof(char *));";
      stream << "\n";
      stream << indent_str;
      stream << "  cmd_line_list_tmp = cmd_line_list;";
      stream << "\n";
      stream << indent_str;
      stream << "  for (i = (n-1); i >= 0; --i)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      (*argv_ptr)[i] = cmd_line_list_tmp->string_arg;";
      stream << "\n";
      stream << indent_str;
      stream << "      cmd_line_list_tmp = cmd_line_list_tmp->next;";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  (*argv_ptr)[n] = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  free(cmdline);";
      stream << "\n";
      stream << indent_str;
      stream << "  return n;";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_string(const char *cmdline, struct ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << " *args_info, const char *prog_name)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  return ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_string2(cmdline, args_info, prog_name, 0, 1, 1);";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_string2(const char *cmdline, struct ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << " *args_info, const char *prog_name,";
      stream << "\n";
      stream << indent_str;
      stream << "    int override, int initialize, int check_required)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  struct ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_params params;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  params.override = override;";
      stream << "\n";
      stream << indent_str;
      stream << "  params.initialize = initialize;";
      stream << "\n";
      stream << indent_str;
      stream << "  params.check_required = check_required;";
      stream << "\n";
      stream << indent_str;
      stream << "  params.check_ambiguity = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  params.print_errors = 1;";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  return ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_string_ext(cmdline, args_info, prog_name, &params);";
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "int";
      stream << "\n";
      stream << indent_str;
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_string_ext(const char *cmdline, struct ";
      generate_string (args_info, stream, indent + indent_str.length ());
      stream << " *args_info, const char *prog_name,";
      stream << "\n";
      stream << indent_str;
      stream << "    struct ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_params *params)";
      stream << "\n";
      stream << indent_str;
      stream << "{";
      stream << "\n";
      stream << indent_str;
      stream << "  char **argv_ptr = 0;";
      stream << "\n";
      stream << indent_str;
      stream << "  int result;";
      stream << "\n";
      stream << indent_str;
      stream << "  unsigned int argc;";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "  argc = ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_create_argv(cmdline, &argv_ptr, prog_name);";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "  result =";
      stream << "\n";
      stream << indent_str;
      indent = 4;
      stream << "    ";
      generate_string (parser_name, stream, indent + indent_str.length ());
      stream << "_internal (argc, argv_ptr, args_info, params, 0);";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "  if (argv_ptr)";
      stream << "\n";
      stream << indent_str;
      stream << "    {";
      stream << "\n";
      stream << indent_str;
      stream << "      free (argv_ptr);";
      stream << "\n";
      stream << indent_str;
      stream << "    }";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
      stream << "  free_cmd_list();";
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      indent = 0;
      stream << "\n";
      stream << indent_str;
      indent = 2;
      stream << "  ";
      generate_string (final_exit, stream, indent + indent_str.length ());
      indent = 0;
      stream << "\n";
      stream << indent_str;
      stream << "}";
      stream << "\n";
      stream << indent_str;
      stream << "\n";
      stream << indent_str;
    }
}
