/* PROGRAM:     testudp
 * FILE:        $Header: /home/egg/src/RCS/testudp.c,v 1.2 1998/07/21 11:34:48 ghn Exp $
 * PURPOSE:     Testing UDP communications (fake basket)
 * AUTHOR:      Greg Nelson
 * DATE:        98-05-09
 *
 * REVISED:     $Log: testudp.c,v $
 * REVISED:     Revision 1.2  1998/07/21 11:34:48  ghn
 * REVISED:     Testing UDP communications (fake basket)
 * REVISED:
 * Copyright 1998 - Greg Nelson
 * Redistributable under the terms of the GNU Public Licence (GPL)
 */

#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <netinet/in.h>
#include "global.h"
#include "genlib.h"
#include "hwapi.h"
#include "collect.h"
#include "storage.h"
#include "network.h"

int main(int argc, char *argv[]) {
  ReqHeader		rhdr;
  struct protoent 	*pp;
  struct hostent	*hp;
  struct sockaddr_in	rhost;
  int32			i;
  int32			out_sock;

  pgmname = argv[0];

  if (argc != 2) {
    printf("Usage: %s <host>\n", pgmname);
    exit(-1);
  }

  if ((pp = getprotobyname("udp")) == NULL) {
    perror("getprotobyname");
    exit(-1);
  }

  if ((hp = gethostbyname(argv[1])) == NULL) {
    fprintf(stderr, "gethostbyname(%s): %s", argv[1], strerror(errno));
    exit(-1);
  }

  if (hp->h_addrtype != AF_INET) {
    fprintf(stderr, "Host is not on the internet!\n");
    exit(-1);
  }

  rhost.sin_port = htons(EGGPORT);
  rhost.sin_family = AF_INET;
  memcpy(&(rhost.sin_addr), hp->h_addr, hp->h_length);

  rhdr.type = REQ_PACKET;
  rhdr.pktsize = sizeof(ReqHeader);
  rhdr.eggid = 30800;	/* halebopp! */
  rhdr.samp_rec = 10;
  rhdr.sec_rec = 10;
  rhdr.rec_pkt = 6;
  rhdr.trialsz = 200;
  rhdr.starttm = 0;
  rhdr.cksum = BlockCRC16((byte *)&rhdr, sizeof(ReqHeader)-2);

  if ((out_sock = socket(AF_INET, SOCK_DGRAM, pp->p_proto)) < 0) {
    perror("socket");
    exit(-1);
  }
	
  i = sendto(out_sock, &rhdr, rhdr.pktsize, 
	     0, (struct sockaddr *)&rhost,
	     sizeof(struct sockaddr));
  if (i == -1) {
    perror("sendto");
    exit(-1);
  }
  if (i != rhdr.pktsize) {
    fprintf(stderr, "Failed to send complete packet (%ld/%d)\n",
	    i, rhdr.pktsize);
    exit(-1);
  }
  
  exit(0);
}
