<?php
namespace DDTrace {
class Type
{
    const CACHE = 'cache';
    const HTTP_CLIENT = 'http';
    const WEB_SERVLET = 'web';
    const CLI = 'cli';
    const SQL = 'sql';
    const QUEUE = 'queue';
    const WEBSOCKET = 'websocket';
    const MESSAGE_CONSUMER = 'queue';
    const MESSAGE_PRODUCER = 'queue';
    const CASSANDRA = 'cassandra';
    const ELASTICSEARCH = 'elasticsearch';
    const MEMCACHED = 'memcached';
    const MONGO = 'mongodb';
    const OPENAI = 'openai';
    const REDIS = 'redis';
    const SYSTEM = 'system';
}
}
namespace DDTrace {
class Tag
{
    const ENV = 'env';
    const SPAN_TYPE = 'span.type';
    const SPAN_KIND = 'span.kind';
    const SPAN_KIND_VALUE_SERVER = 'server';
    const SPAN_KIND_VALUE_CLIENT = 'client';
    const SPAN_KIND_VALUE_PRODUCER = 'producer';
    const SPAN_KIND_VALUE_CONSUMER = 'consumer';
    const SPAN_KIND_VALUE_INTERNAL = 'internal';
    const COMPONENT = 'component';
    const SERVICE_NAME = 'service.name';
    const MANUAL_KEEP = 'manual.keep';
    const MANUAL_DROP = 'manual.drop';
    const PID = 'process_id';
    const RESOURCE_NAME = 'resource.name';
    const DB_STATEMENT = self::DB_STMT;
    const ERROR = 'error';
    const ERROR_MSG = 'error.message';
    const ERROR_TYPE = 'error.type';
    const ERROR_STACK = 'error.stack';
    const HTTP_METHOD = 'http.method';
    const HTTP_ROUTE = 'http.route';
    const HTTP_STATUS_CODE = 'http.status_code';
    const HTTP_URL = 'http.url';
    const HTTP_VERSION = 'http.version';
    const LOG_EVENT = 'event';
    const LOG_ERROR = 'error';
    const LOG_ERROR_OBJECT = 'error.object';
    const LOG_MESSAGE = 'message';
    const LOG_STACK = 'stack';
    const NETWORK_DESTINATION_NAME = 'network.destination.name';
    const TARGET_HOST = 'out.host';
    const TARGET_PORT = 'out.port';
    const BYTES_OUT = 'net.out.bytes';
    const ANALYTICS_KEY = '_dd1.sr.eausr';
    const HOSTNAME = '_dd.hostname';
    const ORIGIN = '_dd.origin';
    const VERSION = 'version';
    const SERVICE_VERSION = 'service.version';
    const ELASTICSEARCH_BODY = 'elasticsearch.body';
    const ELASTICSEARCH_METHOD = 'elasticsearch.method';
    const ELASTICSEARCH_PARAMS = 'elasticsearch.params';
    const ELASTICSEARCH_URL = 'elasticsearch.url';
    const DB_NAME = 'db.name';
    const DB_CHARSET = 'db.charset';
    const DB_INSTANCE = 'db.instance';
    const DB_TYPE = 'db.type';
    const DB_SYSTEM = 'db.system';
    const DB_ROW_COUNT = 'db.row_count';
    const DB_STMT = 'sql.query';
    const DB_USER = 'db.user';
    const KAFKA_CLIENT_ID = 'messaging.kafka.client_id';
    const KAFKA_GROUP_ID = 'messaging.kafka.group_id';
    const KAFKA_HOST_LIST = 'messaging.kafka.bootstrap.servers';
    const KAFKA_MESSAGE_KEY = 'messaging.kafka.message_key';
    const KAFKA_MESSAGE_OFFSET = 'messaging.kafka.message_offset';
    const KAFKA_PARTITION = 'messaging.kafka.partition';
    const KAFKA_TOMBSTONE = 'messaging.kafka.tombstone';
    const KAFKA_PRODUCE = 'kafka.produce';
    const KAFKA_CONSUME = 'kafka.consume';
    const LARAVELQ_ATTEMPTS = 'messaging.laravel.attempts';
    const LARAVELQ_BATCH_ID = 'messaging.laravel.batch_id';
    const LARAVELQ_CONNECTION = 'messaging.laravel.connection';
    const LARAVELQ_MAX_TRIES = 'messaging.laravel.max_tries';
    const LARAVELQ_NAME = 'messaging.laravel.name';
    const LARAVELQ_TIMEOUT = 'messaging.laravel.timeout';
    const MONGODB_BSON_ID = 'mongodb.bson.id';
    const MONGODB_COLLECTION = 'mongodb.collection';
    const MONGODB_DATABASE = 'mongodb.db';
    const MONGODB_PROFILING_LEVEL = 'mongodb.profiling_level';
    const MONGODB_READ_PREFERENCE = 'mongodb.read_preference';
    const MONGODB_SERVER = 'mongodb.server';
    const MONGODB_TIMEOUT = 'mongodb.timeout';
    const MONGODB_QUERY = 'mongodb.query';
    const REDIS_RAW_COMMAND = 'redis.raw_command';
    const MQ_SYSTEM = 'messaging.system';
    const MQ_DESTINATION = 'messaging.destination';
    const MQ_DESTINATION_KIND = 'messaging.destination_kind';
    const MQ_TEMP_DESTINATION = 'messaging.temp_destination';
    const MQ_PROTOCOL = 'messaging.protocol';
    const MQ_PROTOCOL_VERSION = 'messaging.protocol_version';
    const MQ_URL = 'messaging.url';
    const MQ_MESSAGE_ID = 'messaging.message_id';
    const MQ_CONVERSATION_ID = 'messaging.conversation_id';
    const MQ_MESSAGE_PAYLOAD_SIZE = 'messaging.message_payload_size_bytes';
    const MQ_OPERATION = 'messaging.operation';
    const MQ_CONSUMER_ID = 'messaging.consumer_id';
    const MQ_OPERATION_PROCESS = 'process';
    const MQ_OPERATION_RECEIVE = 'receive';
    const MQ_OPERATION_SEND = 'send';
    const RABBITMQ_DELIVERY_MODE = 'messaging.rabbitmq.delivery_mode';
    const RABBITMQ_EXCHANGE = 'messaging.rabbitmq.exchange';
    const RABBITMQ_ROUTING_KEY = 'messaging.rabbitmq.routing_key';
    const EXEC_CMDLINE_EXEC = 'cmd.exec';
    const EXEC_CMDLINE_SHELL = 'cmd.shell';
    const EXEC_TRUNCATED = 'cmd.truncated';
    const EXEC_EXIT_CODE = 'cmd.exit_code';
}
}
namespace DDTrace\Http {
use DDTrace\Obfuscation\WildcardToRegex;
class Urls
{
    private static $defaultPatterns = [
        '<(/)([0-9a-f]{8}-?[0-9a-f]{4}-?[1-5][0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12})(/|$)>i',
        '<(/)([0-9a-f]{8,128})(/|$)>i',
        '<(/)([0-9]+)(/|$)>',
    ];
    private $replacementPatterns = [];
    public function __construct(array $patternsWithWildcards = [])
    {
        foreach ($patternsWithWildcards as $pattern) {
            $this->replacementPatterns[] = WildcardToRegex::convert($pattern);
        }
    }
    public static function sanitize($url, $dropUserInfo = false)
    {
        $url = (string) $url;
        $userinfoPattern = "[a-zA-Z0-9\\-._~!\$&'()*+,;=%?]+";
        $sanitizedUserinfo = preg_replace(
            ["/{$userinfoPattern}:@/", "/{$userinfoPattern}:{$userinfoPattern}@/"],
            [$dropUserInfo ? '' : '<sanitized>:@', $dropUserInfo ? '' : '<sanitized>:<sanitized>@'],
            $url
        );
        return \str_replace('<sanitized>', '?', strstr($sanitizedUserinfo, '?', true) ?: $sanitizedUserinfo);
    }
    public static function hostname($url)
    {
        $url = self::sanitize($url, true);
        $unparsableUrl = 'unparsable-host';
        $parts = \parse_url($url);
        if (!$parts) {
            return $unparsableUrl;
        }
        if (isset($parts['host'])) {
            return $parts['host'];
        }
        if (empty($parts['path'])) {
            return $unparsableUrl;
        }
        $path = $parts['path'];
        if (\substr($path, 0, 1) === '/') {
            return 'unknown-host';
        }
        $pathFragments = \explode('/', $path);
        return $pathFragments[0];
    }
    public static function hostnameForTag($url)
    {
        $url = \trim((string) $url);
        $knownUnixProtocols = ['uds', 'unix', 'http+unix', 'https+unix'];
        foreach ($knownUnixProtocols as $protocol) {
            $length = \strlen($protocol);
            if ($protocol . '://' === \substr($url, 0, $length + 3)) {
                return 'socket-' . Urls::normalizeFileSystemPath(\substr($url, $length + 3));
            }
        }
        return 'host-' . self::hostname($url);
    }
    private static function normalizeFileSystemPath($url)
    {
        return \trim(\preg_replace('/[^0-9a-zA-Z\.]+/', '-', \trim($url)), '-');
    }
    public function normalize($url)
    {
        $url = self::sanitize($url);
        foreach ($this->replacementPatterns as $regexReplacement) {
            list($regex, $replacement) = $regexReplacement;
            $replacedCount = 0;
            $url = preg_replace($regex, $replacement, $url, -1, $replacedCount);
            if ($replacedCount > 0) {
                return $url;
            }
        }
        return preg_replace(self::$defaultPatterns, '$1?$3', $url);
    }
}
}
